/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.texture;

import com.supermartijn642.core.ClientUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6861;

public class TextureMappingTool {
    private static final class_3300 RESOURCE_MANAGER;

    public static Map<Integer, Integer> createPaletteMap(BufferedImage from, BufferedImage to) {
        if (from.getWidth() != to.getWidth() || from.getHeight() != to.getHeight()) {
            throw new IllegalArgumentException("Old palette image must be the same size as new palette image!");
        }
        HashMap<Integer, Integer> palette = new HashMap<Integer, Integer>();
        for (int x = 0; x < from.getWidth(); ++x) {
            for (int y = 0; y < from.getHeight(); ++y) {
                palette.put(from.getRGB(x, y), to.getRGB(x, y));
            }
        }
        return palette;
    }

    public static void applyPaletteMap(BufferedImage image, Map<Integer, Integer> palette, boolean ignoreMissingColors, String name) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int color = image.getRGB(x, y);
                if (color == 0) continue;
                if (!ignoreMissingColors && !palette.containsKey(color)) {
                    throw new IllegalStateException("Palette is missing color '" + String.valueOf(new Color(color)) + "' for pattern '" + name + "'");
                }
                image.setRGB(x, y, palette.getOrDefault(color, color));
            }
        }
    }

    public static List<String> getSuffixes(String name) {
        ArrayList<String> suffixes = new ArrayList<String>();
        RESOURCE_MANAGER.method_29213().filter(pack -> pack.method_14406(class_3264.field_14188).contains("rechiseled")).forEach(pack -> pack.method_14408(class_3264.field_14188, "rechiseled", "textures/block", (s, stream) -> {
            if (s.method_12832().startsWith("textures/block/" + name) && s.method_12832().endsWith(".png")) {
                int beginOffset = s.method_12832().indexOf(name) + name.length();
                int end = s.method_12832().length() - ".png".length();
                suffixes.add(s.method_12832().substring(beginOffset, end));
            }
        }));
        return suffixes;
    }

    public static boolean exists(class_2960 location) {
        return RESOURCE_MANAGER.method_14486(location).isPresent();
    }

    public static class_3298 getResource(class_2960 location) throws NoSuchElementException {
        return (class_3298)RESOURCE_MANAGER.method_14486(location).get();
    }

    static {
        class_3283 packRepository = ClientUtils.getMinecraft().field_1715;
        packRepository.method_14445();
        RESOURCE_MANAGER = new class_6861(class_3264.field_14188, packRepository.method_29211());
    }
}

