/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.EntityBlocker;
import net.xalcon.torchmaster.logic.EntityBlockerSerializer;

public class EntityBlockerSerializerRegistry {
    private static final Map<class_2960, EntityBlockerSerializer<?>> serializers = new HashMap();

    public static void RegisterSerializer(class_2960 type, EntityBlockerSerializer<?> serializer) {
        if (serializers.containsKey(type)) {
            Torchmaster.LOG.error("Serializer with type '{}' was already registered", (Object)type);
            return;
        }
        serializers.put(type, serializer);
    }

    @Nullable
    public static EntityBlocker Deserialize(class_2487 tag) {
        String typeStr = tag.method_10558("_type");
        if (typeStr.isEmpty()) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, empty type");
            return null;
        }
        class_2960 type = class_2960.method_12829((String)typeStr);
        if (type == null) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, can't parse type '{}'", (Object)typeStr);
            return null;
        }
        EntityBlockerSerializer<?> serializer = serializers.get(type);
        if (serializer == null) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, type '{}' not found in registry", (Object)typeStr);
            return null;
        }
        return serializer.DeserializeFrom(tag);
    }

    @Nullable
    public static class_2487 Serialize(EntityBlocker blocker) {
        class_2487 tag = new class_2487();
        class_2960 type = blocker.getType();
        EntityBlockerSerializer<?> serializer = serializers.get(type);
        if (serializer == null) {
            Torchmaster.LOG.error("Serializer for type '{}' not found, unable to save data", (Object)type);
            return null;
        }
        serializer.SerializeInto(tag, blocker);
        tag.method_10582("_type", type.toString());
        return tag;
    }
}

