/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.entityblocking.IBlockingLightManager;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.logic.entityblocking.LightSerializerRegistry;
import net.xalcon.torchmaster.logic.entityblocking.TorchInfo;

public class FilteredLightManager
extends class_18
implements IBlockingLightManager {
    private final Map<String, IEntityBlockingLight> lights = new HashMap<String, IEntityBlockingLight>();
    public static final class_18.class_8645<FilteredLightManager> Factory = new class_18.class_8645(FilteredLightManager::new, FilteredLightManager::load, null);

    @Override
    public boolean shouldBlockEntity(class_1297 entity, class_1937 level, class_3730 spawnType) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockEntity(entity, level, spawnType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBlockVillagePillagerSiege(class_243 pos) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockVillagePillagerSiege(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBlockVillageZombieRaid(class_243 pos) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockVillageZombieRaid(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerLight(String lightKey, IEntityBlockingLight light) {
        this.lights.put(lightKey, light);
        this.method_80();
    }

    @Override
    public void unregisterLight(String lightKey) {
        this.lights.remove(lightKey);
        this.method_80();
    }

    @Override
    public Optional<IEntityBlockingLight> getLight(String lightKey) {
        IEntityBlockingLight light = this.lights.get(lightKey);
        if (light == null) {
            return Optional.empty();
        }
        return Optional.of(light);
    }

    @Override
    public void onGlobalTick(class_1937 level) {
        for (IEntityBlockingLight light : this.lights.values()) {
            light.cleanupCheck(level);
        }
    }

    @Override
    public TorchInfo[] getEntries() {
        return new TorchInfo[0];
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2499 list = new class_2499();
        for (Map.Entry<String, IEntityBlockingLight> pair : this.lights.entrySet()) {
            String lightKey = pair.getKey();
            IEntityBlockingLight light = pair.getValue();
            String serializerType = light.getLightSerializerType();
            LightSerializerRegistry.getLightSerializer(serializerType).ifPresentOrElse(serializer -> {
                class_2487 tag = serializer.serializeLight(light);
                tag.method_10582("_type", serializerType);
                tag.method_10582("_key", lightKey);
                list.add((Object)tag);
            }, () -> Torchmaster.LOG.error("Unable to save light {}, data is lost", (Object)light.getPos()));
        }
        class_2487 tag = new class_2487();
        tag.method_10566("lights", (class_2520)list);
        return tag;
    }

    private static FilteredLightManager load(class_2487 tag, class_7225.class_7874 provider) {
        class_2499 lightsList = tag.method_10554("lights", 10);
        FilteredLightManager mgr = new FilteredLightManager();
        mgr.lights.clear();
        for (int i = 0; i < lightsList.size(); ++i) {
            class_2487 lightNbt = lightsList.method_10602(i);
            String lightKey = lightNbt.method_10558("_key");
            String serializerType = lightNbt.method_10558("_type");
            LightSerializerRegistry.getLightSerializer(serializerType).ifPresentOrElse(serializer -> serializer.deserializeLight(lightNbt).ifPresentOrElse(l -> mgr.lights.put(lightKey, (IEntityBlockingLight)l), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}, deserialization failed, data is lost", (Object)lightKey, (Object)serializerType)), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}. Serializer not found, data is lost", (Object)lightKey, (Object)serializerType));
        }
        return mgr;
    }
}

