/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.EncryptionUtil;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7591;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_338.class})
public class MixinChatComponent {
    @Shadow
    @Final
    private class_310 field_2062;
    private static final class_7591.class_7592 ENCRYPTED_ICON = class_7591.class_7592.valueOf((String)"CHAT_NCR_ENCRYPTED");
    private boolean lastMessageEncrypted;
    private class_2561 lastMessageOriginal;

    @ModifyVariable(method={"addRecentChat"}, at=@At(value="HEAD"), argsOnly=true)
    private String onAddRecentChat(String message) {
        if (NCRConfig.getEncryption().isEnabledAndValid()) {
            return NCRConfig.getEncryption().getLastMessage();
        }
        return message;
    }

    @ModifyVariable(index=-1, method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;logChatMessage(Lnet/minecraft/client/GuiMessage;)V", ordinal=0, shift=At.Shift.BEFORE))
    private class_303 modifyGUIMessage(class_303 msg) {
        if (!NCRConfig.getEncryption().isEnabledAndValid()) {
            return msg;
        }
        if (this.field_2062.field_1687 == null) {
            NCRCore.LOGGER.warn("Chat message cannot be decrypted since level didn't load in yet!");
            return msg;
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Adding chat message, structure: " + class_2561.class_2562.method_10867((class_2561)msg.comp_893(), (class_7225.class_7874)class_5455.field_40585));
        }
        Optional<class_2561> decrypted = EncryptionUtil.tryDecrypt((class_7225.class_7874)this.field_2062.field_1687.method_30349(), msg.comp_893());
        decrypted.ifPresentOrElse(component -> {
            this.lastMessageOriginal = EncryptionUtil.recreate((class_7225.class_7874)this.field_2062.field_1687.method_30349(), msg.comp_893());
            this.lastMessageEncrypted = true;
        }, () -> {
            this.lastMessageEncrypted = false;
        });
        if (this.lastMessageEncrypted) {
            this.lastMessageEncrypted = false;
            class_2561 decryptedComponent = decrypted.get();
            class_7591 newTag = msg.comp_894();
            if (NCRConfig.getEncryption().showEncryptionIndicators()) {
                class_5250 tooltip = class_2561.method_43473().method_10852((class_2561)class_2561.method_43469((String)"tag.nochatreports.encrypted", (Object[])new Object[]{class_2561.method_43470((String)NCRConfig.getEncryption().getAlgorithm().getName()).method_27692(class_124.field_1067)})).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43469((String)"tag.nochatreports.encrypted_original", (Object[])new Object[]{this.lastMessageOriginal}));
                newTag = new class_7591(9125575, ENCRYPTED_ICON, (class_2561)tooltip, "Encrypted");
            }
            return new class_303(msg.comp_892(), decryptedComponent, msg.comp_915(), newTag);
        }
        return msg;
    }
}

