/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core.context;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.context.GameplayContentContext;
import java.util.Objects;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FlattenableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.minecraft.class_1794;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;

public final class GameplayContentContextFabricImpl
implements GameplayContentContext {
    @Override
    public void registerFuel(class_6880<? extends class_1935> fuelItem, Fraction fuelValue) {
        Objects.requireNonNull(fuelItem, "fuel item is null");
        Objects.requireNonNull(fuelValue, "fuel value is null");
        Fraction fuelBaseValue = Fraction.getFraction((int)200, (int)1);
        FuelRegistry.INSTANCE.add((class_1935)fuelItem.comp_349(), (Object)fuelValue.multiplyBy(fuelBaseValue).intValue());
    }

    @Override
    public void registerFlammable(class_6880<class_2248> flammableBlock, int encouragement, int flammability) {
        Preconditions.checkArgument((encouragement > 0 ? 1 : 0) != 0, (Object)"encouragement is non-positive");
        Preconditions.checkArgument((flammability > 0 ? 1 : 0) != 0, (Object)"flammability is non-positive");
        Objects.requireNonNull(flammableBlock, "flammable block is null");
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)flammableBlock.comp_349(), flammability, encouragement);
    }

    @Override
    public void registerCompostable(class_6880<? extends class_1935> compostableItem, float compostingChance) {
        Preconditions.checkArgument((compostingChance >= 0.0f && compostingChance <= 1.0f ? 1 : 0) != 0, (Object)("Value " + compostingChance + " outside of range 0.0 -> 1.0"));
        Objects.requireNonNull(compostableItem, "compostable item is null");
        CompostingChanceRegistry.INSTANCE.add((class_1935)compostableItem.comp_349(), (Object)Float.valueOf(compostingChance));
    }

    @Override
    public void registerStrippable(class_6880<class_2248> unstrippedBlock, class_6880<class_2248> strippedBlock) {
        Objects.requireNonNull(unstrippedBlock, "unstripped block is null");
        Objects.requireNonNull(strippedBlock, "stripped block is null");
        StrippableBlockRegistry.register((class_2248)((class_2248)unstrippedBlock.comp_349()), (class_2248)((class_2248)strippedBlock.comp_349()));
    }

    @Override
    public void registerFlattenable(class_6880<class_2248> unflattenedBlock, class_6880<class_2248> flattenedBlock) {
        Objects.requireNonNull(unflattenedBlock, "unflattened block is null");
        Objects.requireNonNull(flattenedBlock, "flattened block is null");
        FlattenableBlockRegistry.register((class_2248)((class_2248)unflattenedBlock.comp_349()), (class_2680)((class_2248)flattenedBlock.comp_349()).method_9564());
    }

    @Override
    public void registerTillable(class_6880<class_2248> untilledBlock, class_6880<class_2248> tilledBlock) {
        Objects.requireNonNull(untilledBlock, "untilled block is null");
        Objects.requireNonNull(tilledBlock, "tilled block is null");
        TillableBlockRegistry.register((class_2248)((class_2248)untilledBlock.comp_349()), class_1794::method_36987, (class_2680)((class_2248)tilledBlock.comp_349()).method_9564());
    }

    @Override
    public void registerOxidizable(class_6880<class_2248> unoxidizedBlock, class_6880<class_2248> oxidizedBlock) {
        Objects.requireNonNull(unoxidizedBlock, "unoxidized block is null");
        Objects.requireNonNull(oxidizedBlock, "oxidized block is null");
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)((class_2248)unoxidizedBlock.comp_349()), (class_2248)((class_2248)oxidizedBlock.comp_349()));
    }

    @Override
    public void registerWaxable(class_6880<class_2248> unwaxedBlock, class_6880<class_2248> waxedBlock) {
        Objects.requireNonNull(unwaxedBlock, "unwaxed block is null");
        Objects.requireNonNull(waxedBlock, "waxed block is null");
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)((class_2248)unwaxedBlock.comp_349()), (class_2248)((class_2248)waxedBlock.comp_349()));
    }
}

