/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.RadioButton;
import journeymap.client.ui.component.widgets.StringWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public abstract class RadioButtonListWidget<T>
extends class_8667 {
    protected static final int VERTICAL_PADDING = 3;
    protected static final int HORIZONTAL_PADDING = 6;
    protected final Collection<T> values;
    protected final int MAX_ROWS = 4;
    protected int columnCt = 1;
    protected T enabledValue;
    protected final Map<RadioButton, T> buttonValueMap;
    protected final class_7845 buttonGrid;
    protected final OnChange<T> onChange;

    public RadioButtonListWidget(String titleKey, Collection<T> values, T enabledValue, OnChange<T> onChange) {
        super(0, 0, class_8667.class_8668.field_45404);
        this.onChange = onChange;
        this.method_52738((class_8021)new Title(titleKey, class_310.method_1551().field_1772, this), class_7847::method_46467);
        this.method_52735(6);
        this.values = values;
        this.enabledValue = enabledValue;
        this.buttonValueMap = new LinkedHashMap<RadioButton, T>();
        this.buttonGrid = new class_7845();
    }

    public void method_48206(Consumer<class_339> consumer) {
        this.buildButtonGrid();
        super.method_48206(consumer);
    }

    protected void buildButtonGrid() {
        this.buttonGrid.method_48636(4);
        this.buttonGrid.method_48635(3);
        int row = 0;
        int column = 0;
        for (T value : this.values) {
            if (row >= 4) {
                ++column;
                ++this.columnCt;
                row = 0;
            }
            RadioButton button = this.createRadioButton(value);
            this.buttonValueMap.put(button, value);
            this.buttonGrid.method_46452((class_8021)button, row++, column);
        }
        this.method_52738((class_8021)this.buttonGrid, class_7847::method_46467);
    }

    abstract RadioButton createRadioButton(T var1);

    protected void onPress(class_4185 button) {
        RadioButton radio = (RadioButton)button;
        this.buttonValueMap.forEach((b, t) -> b.setState(false));
        radio.setState(true);
        this.onChange.onChange(this.buttonValueMap.get((Object)radio));
    }

    protected void render(class_332 graphics, int mouseX, int mouseY) {
        int startX = this.buttonGrid.method_46426() - 6;
        int startY = this.buttonGrid.method_46427() - 3;
        int width = startX + this.buttonGrid.method_25368() + 12;
        int height = startY + this.buttonGrid.method_25364() + 6;
        int color = RGB.toArgb(0x404040, 1.0f);
        graphics.method_25292(startX, width, startY, color);
        graphics.method_25292(startX, width, height, color);
        graphics.method_25301(startX, startY, height, color);
        graphics.method_25301(width, startY, height, color);
    }

    public static interface OnChange<T> {
        public void onChange(T var1);
    }

    private static class Title
    extends StringWidget {
        private final RadioButtonListWidget parent;

        public Title(String key, class_327 font, RadioButtonListWidget parent) {
            super((class_2561)class_2561.method_43471((String)key).method_27692(class_124.field_1075).method_27692(class_124.field_1073), font);
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(key + ".tooltip"))));
            this.parent = parent;
        }

        @Override
        public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.parent.render(guiGraphics, mouseX, mouseY);
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

