/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import io.wispforest.owo.util.Observable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class SlimSliderComponent
extends BaseComponent {
    public static final Function<Double, class_2561> VALUE_TOOLTIP_SUPPLIER = value -> class_2561.method_43470((String)String.valueOf(value));
    protected static final class_2960 TEXTURE = class_2960.method_60655((String)"owo", (String)"textures/gui/slim_slider.png");
    protected static final class_2960 TRACK_TEXTURE = class_2960.method_60655((String)"owo", (String)"slim_slider_track");
    protected final EventStream<OnChanged> changedEvents = OnChanged.newStream();
    protected final EventStream<OnSlideEnd> slideEndEvents = OnSlideEnd.newStream();
    protected final Axis axis;
    protected final Observable<Double> value = Observable.of(0.0);
    protected double min = 0.0;
    protected double max = 1.0;
    protected double stepSize = 0.0;
    @Nullable
    protected Function<Double, class_2561> tooltipSupplier = null;

    public SlimSliderComponent(Axis axis) {
        this.cursorStyle(CursorStyle.MOVE);
        this.axis = axis;
        this.value.observe($ -> {
            this.changedEvents.sink().onChanged(this.value());
            this.updateTooltip();
        });
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        if (this.axis == Axis.VERTICAL) {
            return 9;
        }
        throw new UnsupportedOperationException("Horizontal SlimSliderComponent cannot be horizontally content-sized");
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        if (this.axis == Axis.HORIZONTAL) {
            return 9;
        }
        throw new UnsupportedOperationException("Vertical SlimSliderComponent cannot be vertically content-sized");
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.axis == Axis.HORIZONTAL) {
            NinePatchTexture.draw(TRACK_TEXTURE, context, this.x + 1, this.y + 3, this.width - 2, 3);
            context.method_25293(TEXTURE, (int)((double)this.x + (double)(this.width - 4) * this.value.get()), this.y + 1, 4, 7, 0.0f, 3.0f, 4, 7, 16, 16);
        } else {
            NinePatchTexture.draw(TRACK_TEXTURE, context, this.x + 3, this.y + 1, 3, this.height - 2);
            context.method_25293(TEXTURE, this.x + 1, (int)((double)this.y + (double)(this.height - 4) * this.value.get()), 7, 4, 4.0f, 3.0f, 7, 4, 16, 16);
        }
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        this.setValueFromMouse(mouseX, mouseY);
        return true;
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        this.setValueFromMouse(mouseX, mouseY);
        return true;
    }

    @Override
    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        this.slideEndEvents.sink().onSlideEnd();
        return true;
    }

    protected void setValueFromMouse(double mouseX, double mouseY) {
        this.value(this.axis == Axis.VERTICAL ? this.min + mouseY / (double)this.height * (this.max - this.min) : this.min + mouseX / (double)this.width * (this.max - this.min));
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return true;
    }

    public EventSource<OnChanged> onChanged() {
        return this.changedEvents.source();
    }

    public EventSource<OnSlideEnd> onSlideEnd() {
        return this.slideEndEvents.source();
    }

    public SlimSliderComponent value(double value) {
        value -= this.min;
        if (this.stepSize != 0.0) {
            value = (double)Math.round(value / this.stepSize) * this.stepSize;
        }
        this.value.set(class_3532.method_15350((double)(value / (this.max - this.min)), (double)0.0, (double)1.0));
        return this;
    }

    public double value() {
        return this.min + this.value.get() * (this.max - this.min);
    }

    public SlimSliderComponent min(double min) {
        this.min = min;
        return this;
    }

    public double min() {
        return this.min;
    }

    public SlimSliderComponent max(double max) {
        this.max = max;
        return this;
    }

    public double max() {
        return this.max;
    }

    public SlimSliderComponent stepSize(double stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    public double stepSize() {
        return this.stepSize;
    }

    public SlimSliderComponent tooltipSupplier(Function<Double, class_2561> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        this.updateTooltip();
        return this;
    }

    public Function<Double, class_2561> tooltipSupplier() {
        return this.tooltipSupplier;
    }

    protected void updateTooltip() {
        if (this.tooltipSupplier != null) {
            this.tooltip(this.tooltipSupplier.apply(this.value()));
        } else {
            this.tooltip((List<class_5684>)null);
        }
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "step-size", UIParsing::parseDouble, this::stepSize);
        UIParsing.apply(children, "min", UIParsing::parseDouble, this::min);
        UIParsing.apply(children, "max", UIParsing::parseDouble, this::max);
        UIParsing.apply(children, "value", UIParsing::parseDouble, this::value);
    }

    public static Component parse(Element element) {
        return element.getAttribute("direction").equals("vertical") ? new SlimSliderComponent(Axis.VERTICAL) : new SlimSliderComponent(Axis.HORIZONTAL);
    }

    public static Function<Double, class_2561> valueTooltipSupplier(int decimalPlaces) {
        return value -> class_2561.method_43470((String)new BigDecimal((double)value).setScale(decimalPlaces, RoundingMode.HALF_UP).toPlainString());
    }

    public static interface OnChanged {
        public void onChanged(double var1);

        public static EventStream<OnChanged> newStream() {
            return new EventStream<OnChanged>(subscribers -> value -> {
                for (OnChanged subscriber : subscribers) {
                    subscriber.onChanged(value);
                }
            });
        }
    }

    public static interface OnSlideEnd {
        public void onSlideEnd();

        public static EventStream<OnSlideEnd> newStream() {
            return new EventStream<OnSlideEnd>(subscribers -> () -> {
                for (OnSlideEnd subscriber : subscribers) {
                    subscriber.onSlideEnd();
                }
            });
        }
    }

    public static enum Axis {
        VERTICAL,
        HORIZONTAL;

    }
}

