/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.util;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.mixin.accessor.EndDragonFightAccessor;
import com.yungnickyoung.minecraft.betterendisland.world.IBetterDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndPodiumFeature;
import com.yungnickyoung.minecraft.betterendisland.world.util.WorldgenUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3033;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class ExitPortalUtils {
    public static void spawnPortal(IBetterDragonFight dragonFight, class_3218 serverLevel, boolean isActive, boolean isBottomOnly, boolean noCrystalsOverride) {
        boolean useBetterPortal = dragonFight.hasDragonEverSpawned() ? BetterEndIslandCommon.CONFIG.spawnCentralTowerOnResummon : BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially;
        EndDragonFightAccessor fightAccessor = (EndDragonFightAccessor)((Object)dragonFight);
        fightAccessor.setPortalLocation(ExitPortalUtils.getAdjustedPortalPos(fightAccessor.getPortalLocation(), serverLevel));
        if (useBetterPortal) {
            BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(dragonFight.isFirstExitPortalSpawn(), isBottomOnly, isActive);
            class_2338 spawnPos = fightAccessor.getPortalLocation().method_10087(5);
            endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)serverLevel, serverLevel.method_14178().method_12129(), class_5819.method_43047(), spawnPos);
        } else {
            class_3033 endPodiumFeature = new class_3033(isActive);
            class_2338 spawnPos = fightAccessor.getPortalLocation().method_10087(3);
            if (!dragonFight.hasDragonEverSpawned() || !BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially) {
                spawnPos = spawnPos.method_10086(4);
            }
            if (endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)serverLevel, serverLevel.method_14178().method_12129(), class_5819.method_43047(), spawnPos)) {
                int $$2 = class_3532.method_38788((int)4, (int)16);
                serverLevel.method_14178().field_17254.method_53685(new class_1923(spawnPos), $$2);
            }
            if (!dragonFight.hasDragonEverSpawned() && !noCrystalsOverride) {
                class_2338 centerPos = spawnPos.method_10086(1);
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 crystalPos = centerPos.method_10079(direction, 3);
                    class_1511 crystal = new class_1511((class_1937)serverLevel, (double)crystalPos.method_10263() + 0.5, (double)crystalPos.method_10264(), (double)crystalPos.method_10260() + 0.5);
                    crystal.method_6839(false);
                    crystal.method_5684(true);
                    serverLevel.method_8649((class_1297)crystal);
                }
            }
        }
        dragonFight.setIsFirstExitPortalSpawn(false);
    }

    public static void spawnPortal(IBetterDragonFight dragonFight, class_3218 serverLevel, boolean isActive, boolean isBottomOnly) {
        ExitPortalUtils.spawnPortal(dragonFight, serverLevel, isActive, isBottomOnly, false);
    }

    private static class_2338 getAdjustedPortalPos(class_2338 portalLocation, class_3218 serverLevel) {
        class_2338 portalPos = portalLocation;
        if (portalPos == null || portalPos.method_10264() < 5) {
            if (portalPos == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is null. Placing manually...");
            } else {
                BetterEndIslandCommon.LOGGER.info("Portal location is too low: {}. Placing manually...", (Object)portalPos.method_10264());
            }
            portalPos = new class_2338(0, WorldgenUtils.getSurfacePosAt((class_1937)serverLevel, 0, 0), 0);
            while (serverLevel.method_8320(portalPos).method_27852(class_2246.field_9987) && portalPos.method_10264() > serverLevel.method_8615()) {
                portalPos = portalPos.method_10074();
            }
            if (portalPos.method_10264() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal was still placed too low! Force placing at y=65...");
                portalPos = new class_2338(0, 65, 0);
            }
        }
        BetterEndIslandCommon.LOGGER.info("Set the exit portal location to: {}", (Object)portalPos);
        return portalPos;
    }
}

