/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.fabric;

import java.util.HashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9168;
import tech.thatgravyboat.creeperoverhaul.Creepers;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSpawns;
import tech.thatgravyboat.creeperoverhaul.common.registry.fabric.FabricAttributes;
import tech.thatgravyboat.creeperoverhaul.fabric.PluginLoader;

public class CreepersFabric
implements ModInitializer {
    private static final class_6862<class_1959> IS_DARKFOREST = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"c", (String)"is_dark_forest"));
    private static final class_6862<class_1959> IS_MUSHROOM = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"c", (String)"is_mushroom"));

    public void onInitialize() {
        Creepers.init();
        FabricAttributes.register();
        HashMap<class_1299<? extends class_1309>, class_5132.class_5133> attributes = new HashMap<class_1299<? extends class_1309>, class_5132.class_5133>();
        Creepers.registerAttributes(attributes);
        attributes.forEach(FabricDefaultAttributeRegistry::register);
        this.addCreepers();
        this.removeCreepers();
        ModSpawns.addSpawnRules(new ModSpawns.Registrar(this){

            @Override
            public <T extends class_1308> void register(Supplier<class_1299<T>> entityType, class_9168 type, class_2902.class_2903 types, class_1317.class_4306<T> spawnPredicate) {
                class_1317.method_20637(entityType.get(), (class_9168)type, (class_2902.class_2903)types, spawnPredicate);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(event -> PluginLoader.load());
    }

    public void addCreepers() {
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BEACH), ModEntities.BEACH_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BEACH), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SNOWY), ModEntities.SNOWY_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SNOWY), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_DESERT), ModEntities.DESERT_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_DESERT), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_HILL), ModEntities.HILLS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_HILL), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SAVANNA), ModEntities.SAVANNAH_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SAVANNA), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BADLANDS), ModEntities.BADLANDS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BADLANDS), ModEntities.CAVE_CREEPER, 50);
        BiomeModifications.addSpawn(CreepersFabric.tag(IS_MUSHROOM), (class_1311)ModEntities.MUSHROOM_CREEPER.get().method_5891(), ModEntities.MUSHROOM_CREEPER.get(), (int)10, (int)1, (int)2);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_TAIGA), ModEntities.SPRUCE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_TAIGA), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_MOUNTAIN).and(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SNOWY)), ModEntities.HILLS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_MOUNTAIN), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_CAVE).and(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.NO_DEFAULT_MONSTERS).negate()), ModEntities.DRIPSTONE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_CAVE).and(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.NO_DEFAULT_MONSTERS).negate()), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_JUNGLE), ModEntities.BAMBOO_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_JUNGLE), ModEntities.JUNGLE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_JUNGLE), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SWAMP), ModEntities.SWAMP_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SWAMP), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag(IS_DARKFOREST), ModEntities.DARK_OAK_CREEPER);
        this.addCreeper(CreepersFabric.tag(IS_DARKFOREST), ModEntities.CAVE_CREEPER, 50);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BIRCH_FOREST), ModEntities.BIRCH_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BIRCH_FOREST), ModEntities.CAVE_CREEPER, 50);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9441, class_1972.field_9408, class_1972.field_9439}), (class_1311)ModEntities.OCEAN_CREEPER.get().method_5891(), ModEntities.OCEAN_CREEPER.get(), (int)2, (int)1, (int)1);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9441, class_1972.field_9408, class_1972.field_9439}), ModEntities.CAVE_CREEPER, 50);
    }

    public void removeCreepers() {
        Predicate<BiomeSelectionContext> creepersToRemove = CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BEACH).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SNOWY)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_DESERT)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_HILL)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SAVANNA)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BADLANDS)).or(CreepersFabric.tag(IS_MUSHROOM)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_TAIGA)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_MOUNTAIN)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_CAVE)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_JUNGLE)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_SWAMP)).or(CreepersFabric.tag(IS_DARKFOREST)).or(CreepersFabric.tag((class_6862<class_1959>)ConventionalBiomeTags.IS_BIRCH_FOREST)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9408, class_1972.field_9441, class_1972.field_9439}));
        this.removeCreeper(creepersToRemove);
    }

    private static Predicate<BiomeSelectionContext> tag(class_6862<class_1959> tag) {
        return BiomeSelectors.tag(tag);
    }

    private <E extends BaseCreeper> void addCreeper(Predicate<BiomeSelectionContext> selectors, Supplier<class_1299<E>> entityType) {
        this.addCreeper(selectors, entityType, 75);
    }

    private <E extends BaseCreeper> void addCreeper(Predicate<BiomeSelectionContext> selectors, Supplier<class_1299<E>> entityType, int weight) {
        BiomeModifications.addSpawn(selectors.and(BiomeSelectors.foundInOverworld()), (class_1311)entityType.get().method_5891(), entityType.get(), (int)weight, (int)2, (int)2);
    }

    private void removeCreeper(Predicate<BiomeSelectionContext> biomeSelector) {
        class_2960 id = class_7923.field_41177.method_10221((Object)class_1299.field_6046);
        BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector, context -> context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6046));
    }
}

