/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_4730;

public class LimitedPillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> CENTER = List.of(AthenaQuad.withSprite(2));
    private static final List<AthenaQuad> TOP = List.of(AthenaQuad.withSprite(1));
    private static final List<AthenaQuad> BOTTOM = List.of(AthenaQuad.withSprite(3));
    private static final List<AthenaQuad> SELF = List.of(AthenaQuad.withSprite(4));
    private static final List<AthenaQuad> CAP = List.of(AthenaQuad.withSprite(0));
    private final Int2ObjectMap<class_4730> materials;

    public LimitedPillarBlockModel(Int2ObjectMap<class_4730> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        boolean max;
        class_2338 occludingPos = pos.method_10093(direction);
        class_2680 appearance = level.getAppearance(state, pos, direction, level.method_8320(occludingPos), occludingPos);
        class_2680 occludingAppearance = level.getAppearance(occludingPos, direction.method_10153(), state, pos);
        if (!appearance.method_26215() && occludingAppearance.method_27852(appearance.method_26204())) {
            return List.of();
        }
        if (direction.method_10166().method_10178()) {
            return CAP;
        }
        class_2338 posAbove = pos.method_10084();
        class_2338 posBelow = pos.method_10074();
        class_2680 appearanceAbove = level.getAppearance(state, pos, direction, level.method_8320(posAbove), posAbove);
        class_2680 appearanceBelow = level.getAppearance(state, pos, direction, level.method_8320(posBelow), posBelow);
        boolean min = !appearanceAbove.method_26215() && level.getAppearance(posAbove, direction, state, pos).method_27852(appearanceAbove.method_26204());
        boolean bl = max = !appearanceBelow.method_26215() && level.getAppearance(posBelow, direction, state, pos).method_27852(appearanceBelow.method_26204());
        if (min && max) {
            return CENTER;
        }
        if (min) {
            return BOTTOM;
        }
        if (max) {
            return TOP;
        }
        return SELF;
    }

    @Override
    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(class_2350 direction) {
        HashMap<class_2350, List<AthenaQuad>> quads = new HashMap<class_2350, List<AthenaQuad>>(class_2350.values().length);
        for (class_2350 dir : class_2350.values()) {
            quads.put(dir, SELF);
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((class_4730)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<class_4730> materials = Factory.parseMaterials(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"));
            return () -> new LimitedPillarBlockModel(materials);
        }

        private static Int2ObjectMap<class_4730> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"bottom")));
            return materials;
        }
    }
}

