/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4496;
import net.minecraft.class_4592;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import samebutdifferent.ecologics.entity.Penguin;

@Environment(value=EnvType.CLIENT)
public class PenguinModel
extends class_4592<Penguin> {
    public static final class_5601 LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"ecologics", (String)"penguin"), "main");
    private final class_630 body;
    public final class_630 head;
    private final class_630 leftFlipper;
    private final class_630 rightFlipper;
    private final class_630 egg;
    private final class_630 leftFoot;
    private final class_630 rightFoot;
    private float slidingAnimationProgress;
    private float swimmingAnimationProgress;

    public PenguinModel(class_630 root) {
        super(true, 4.75f, 0.0f, 1.5f, 2.0f, 24.0f);
        this.body = root.method_32086("body");
        this.head = root.method_32086("head");
        this.leftFlipper = this.body.method_32086("leftFlipper");
        this.rightFlipper = this.body.method_32086("rightFlipper");
        this.egg = this.body.method_32086("egg");
        this.leftFoot = this.body.method_32086("leftFoot");
        this.rightFoot = this.body.method_32086("rightFoot");
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        class_5610 head = partdefinition.method_32117("head", class_5606.method_32108().method_32101(0, 16).method_32098(-3.0f, -5.0f, -3.0f, 6.0f, 5.0f, 6.0f, new class_5605(0.0f)).method_32101(23, 0).method_32098(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 2.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)15.0f, (float)0.0f));
        class_5610 body = partdefinition.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -2.0f, -3.0f, 8.0f, 9.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)17.0f, (float)0.0f));
        class_5610 leftFlipper = body.method_32117("leftFlipper", class_5606.method_32108().method_32101(18, 21).method_32098(0.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new class_5605(0.0f)), class_5603.method_32090((float)4.0f, (float)-1.0f, (float)0.0f));
        class_5610 rightFlipper = body.method_32117("rightFlipper", class_5606.method_32108().method_32101(18, 21).method_32096().method_32098(-1.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)-4.0f, (float)-1.0f, (float)0.0f));
        class_5610 egg = body.method_32117("egg", class_5606.method_32108().method_32101(31, 0).method_32098(-1.5f, -4.0f, -6.0f, 3.0f, 4.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)7.0f, (float)0.0f));
        class_5610 leftFoot = body.method_32117("leftFoot", class_5606.method_32108().method_32101(16, 16).method_32098(-1.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new class_5605(0.0f)), class_5603.method_32090((float)2.0f, (float)7.0f, (float)-3.0f));
        class_5610 rightFoot = body.method_32117("rightFoot", class_5606.method_32108().method_32101(16, 16).method_32096().method_32098(-2.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)-2.0f, (float)7.0f, (float)-3.0f));
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Penguin entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.method_2816((class_1297)entity, limbSwing, limbSwingAmount, partialTick);
        this.slidingAnimationProgress = entity.getSlidingAnimationProgress(partialTick);
        this.swimmingAnimationProgress = entity.getSwimmingAnimationProgress(partialTick);
    }

    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.method_32088().forEach(class_630::method_41923);
        this.egg.field_3665 = entity.isPregnant();
        this.head.method_41923();
        float swingSlowdownFactor = 0.3f;
        if (this.swimmingAnimationProgress > 0.0f) {
            this.body.field_3654 += class_4496.method_22114((float)this.body.field_3654, (float)((float)Math.toRadians(90.0)), (float)this.swimmingAnimationProgress) - class_3532.method_15362((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.25f);
            this.body.field_3656 = class_3532.method_16439((float)this.swimmingAnimationProgress, (float)this.body.method_41921().field_27703, (float)(this.body.method_41921().field_27703 + 7.0f));
            this.body.field_3656 += -class_3532.method_15362((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.025f);
            this.head.field_3654 = class_3532.method_16439((float)this.swimmingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.field_3675 = class_3532.method_16439((float)this.swimmingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.field_3656 = class_3532.method_16439((float)this.swimmingAnimationProgress, (float)this.head.method_41921().field_27703, (float)(entity.method_6109() ? 21.0f : 24.0f));
            this.head.field_3655 = class_3532.method_16439((float)this.swimmingAnimationProgress, (float)this.head.method_41921().field_27704, (float)-2.0f);
            this.head.field_3654 += class_3532.method_15362((float)(0.7f * ((float)Math.toRadians(-40.0) + ageInTicks))) * (swingSlowdownFactor * 0.3f);
            this.leftFoot.field_3654 = (float)((double)this.leftFoot.field_3654 + (Math.toRadians(17.5) - (double)class_3532.method_15362((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.rightFoot.field_3654 = (float)((double)this.rightFoot.field_3654 + (Math.toRadians(17.5) - (double)class_3532.method_15374((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.leftFlipper.field_3654 += class_3532.method_15362((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.leftFlipper.field_3674 = (float)((double)this.leftFlipper.field_3674 + (Math.toRadians(-5.0) - (double)class_3532.method_15362((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
            this.rightFlipper.field_3654 += class_3532.method_15362((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.rightFlipper.field_3674 = (float)((double)this.rightFlipper.field_3674 + (Math.toRadians(5.0) - (double)class_3532.method_15362((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
        } else if (this.slidingAnimationProgress > 0.0f) {
            this.body.field_3654 += class_4496.method_22114((float)this.body.field_3654, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.body.field_3656 = class_3532.method_16439((float)this.slidingAnimationProgress, (float)this.body.method_41921().field_27703, (float)(this.body.method_41921().field_27703 + 7.0f));
            this.body.field_3655 += -class_3532.method_15362((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.head.field_3654 = class_3532.method_16439((float)this.slidingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.field_3675 = class_3532.method_16439((float)this.slidingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.field_3656 = class_3532.method_16439((float)this.slidingAnimationProgress, (float)this.head.method_41921().field_27703, (float)(entity.method_6109() ? 20.0f : 24.0f));
            this.head.field_3655 = class_3532.method_16439((float)this.slidingAnimationProgress, (float)this.head.method_41921().field_27704, (float)-4.0f);
            this.head.field_3656 += -class_3532.method_15362((float)(2.0f * ((float)Math.toRadians(-80.0) + limbSwing))) * swingSlowdownFactor * limbSwingAmount;
            this.head.field_3655 += -class_3532.method_15362((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.leftFoot.field_3654 += class_4496.method_22114((float)this.leftFoot.field_3654, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.rightFoot.field_3654 += class_4496.method_22114((float)this.rightFoot.field_3654, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.leftFlipper.field_3674 = (float)((double)this.leftFlipper.field_3674 + (Math.toRadians(-2.5) - (double)class_3532.method_15362((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
            this.rightFlipper.field_3674 = (float)((double)this.rightFlipper.field_3674 + (Math.toRadians(2.5) - (double)class_3532.method_15362((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
        } else {
            this.body.field_3675 += class_3532.method_15362((float)((float)Math.toRadians(-20.0) + limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.body.field_3674 += class_3532.method_15362((float)limbSwing) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.field_3654 = headPitch * ((float)Math.PI / 180);
            this.head.field_3675 = netHeadYaw * ((float)Math.PI / 180);
            this.head.field_3675 += -class_3532.method_15362((float)((float)Math.toRadians(-80.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.field_3674 += -class_3532.method_15362((float)((float)Math.toRadians(-40.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.field_3657 += class_3532.method_15362((float)limbSwing) * (swingSlowdownFactor * 0.1f) * limbSwingAmount;
            this.leftFoot.field_3654 = (float)((double)this.leftFoot.field_3654 + (Math.toRadians(-10.0) + (double)class_3532.method_15362((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.rightFoot.field_3654 = (float)((double)this.rightFoot.field_3654 + (Math.toRadians(-10.0) - (double)class_3532.method_15362((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.leftFlipper.field_3674 = (float)((double)this.leftFlipper.field_3674 + (Math.toRadians(-10.0) + (double)class_3532.method_15362((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
            this.rightFlipper.field_3674 = (float)((double)this.rightFlipper.field_3674 + (Math.toRadians(10.0) + (double)class_3532.method_15362((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
        }
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body);
    }
}

