/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_15;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5757;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import samebutdifferent.ecologics.registry.ModTags;

public class Penguin
extends class_1429 {
    private static final class_2940<Boolean> PREGNANT = class_2945.method_12791(Penguin.class, (class_2941)class_2943.field_13323);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS);
    private float slideAnimationProgress;
    private float lastSlideAnimationProgress;
    private float swimAnimationProgress;
    private float lastSwimAnimationProgress;
    private int ticksSinceEaten;

    public Penguin(class_1299<? extends class_1429> type, class_1937 level) {
        super(type, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.4f, 1.0f, true);
        this.field_6206 = new PenguinLookControl((class_1308)this, 20);
        this.method_5952(true);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_47761, 1.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, (Predicate)FOOD_ITEMS, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new PenguinSearchForItemsGoal(this));
        this.field_6201.method_6277(6, (class_1352)new PenguinMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new PenguinRandomSwimmingGoal(this, 1.0, 60));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new PenguinAttackTargetGoal<class_1422>(this, class_1422.class, 10, true, false, living -> living.method_5864().method_20210(ModTags.EntityTypeTags.PENGUIN_HUNT_TARGETS)));
    }

    public static boolean checkPenguinSpawnRules(class_1299<Penguin> entityType, class_1936 levelAccessor, class_3730 mobSpawnType, class_2338 blockPos, class_5819 randomSource) {
        return levelAccessor.method_8320(blockPos.method_10074()).method_26164(ModTags.BlockTags.PENGUINS_SPAWNABLE_ON) && Penguin.method_39448((class_1920)levelAccessor, (class_2338)blockPos);
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        return new PenguinPathNavigation(this, pLevel);
    }

    public int method_5748() {
        return 2400;
    }

    public boolean method_5675() {
        return false;
    }

    public void method_6091(class_243 pTravelVector) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), pTravelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(pTravelVector);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)ModEntityTypes.PENGUIN.method_5883((class_1937)level);
    }

    public boolean method_6481(class_1799 pStack) {
        return FOOD_ITEMS.method_8093(pStack);
    }

    public boolean isPregnant() {
        return (Boolean)this.field_6011.method_12789(PREGNANT);
    }

    public void setPregnant(boolean isPregnant) {
        this.field_6011.method_12778(PREGNANT, (Object)isPregnant);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PREGNANT, (Object)false);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10556("IsPregnant", this.isPregnant());
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setPregnant(pCompound.method_10577("IsPregnant"));
    }

    public void method_24650(class_3218 level, class_1429 otherParent) {
        class_3222 serverplayer = this.method_6478();
        if (serverplayer == null && otherParent.method_6478() != null) {
            serverplayer = otherParent.method_6478();
        }
        if (serverplayer != null) {
            serverplayer.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(serverplayer, (class_1429)this, otherParent, null);
        }
        this.method_5614(6000);
        otherParent.method_5614(6000);
        this.method_6477();
        otherParent.method_6477();
        level.method_8421((class_1297)this, (byte)18);
        this.setPregnant(true);
        if (level.method_8450().method_8355(class_1928.field_19391)) {
            level.method_8649((class_1297)new class_1303((class_1937)level, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
        }
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_6109() && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
            this.method_5870((class_1935)ModItems.PENGUIN_FEATHER, 1);
        }
    }

    public void method_6007() {
        if (this.isPregnant() && this.field_5974.method_43048(3000) == 0 && !this.method_37908().method_8608()) {
            class_3218 level = (class_3218)this.method_37908();
            this.setPregnant(false);
            Penguin penguin = (Penguin)ModEntityTypes.PENGUIN.method_5883((class_1937)level);
            penguin.method_7217(true);
            penguin.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
            level.method_30771((class_1297)penguin);
            level.method_8421((class_1297)this, (byte)18);
        }
        if (this.method_37908().method_8510() % 80L == 0L && this.method_37908().method_18467(Penguin.class, this.method_5829().method_1014(20.0)).size() > 4) {
            for (class_1657 player : this.method_37908().method_18467(class_1657.class, this.method_5829().method_1014(10.0))) {
                player.method_6092(new class_1293(class_1294.field_5924, 100, 0, true, true));
            }
        }
        if (!this.method_37908().method_8608() && this.method_5805() && this.method_6034()) {
            ++this.ticksSinceEaten;
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (this.canEat(stack)) {
                if (this.ticksSinceEaten > 600) {
                    class_1799 finishedStack = stack.method_7910(this.method_37908(), (class_1309)this);
                    if (!finishedStack.method_7960()) {
                        this.method_5673(class_1304.field_6173, finishedStack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.field_5974.method_43057() < 0.1f) {
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                }
            }
        }
        super.method_6007();
    }

    private boolean canEat(class_1799 itemStack) {
        return itemStack.method_57824(class_9334.field_50075) != null && this.method_5968() == null && this.method_24828();
    }

    public void method_5711(byte id) {
        if (id == 45) {
            class_1799 itemStack = this.method_6118(class_1304.field_6173);
            if (!itemStack.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 vec3 = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, vec3.field_1352, vec3.field_1351 + 0.05, vec3.field_1350);
                }
            }
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_18397(class_1799 pItemstack) {
        class_1304 equipmentslot = this.method_32326(pItemstack);
        if (!this.method_6118(equipmentslot).method_7960() || this.method_6109()) {
            return false;
        }
        return equipmentslot == class_1304.field_6173 && super.method_18397(pItemstack);
    }

    public boolean method_5939(class_1799 pStack) {
        class_1799 itemstack = this.method_6118(class_1304.field_6173);
        return itemstack.method_7960() && pStack.method_31573(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS) && !this.method_6109();
    }

    protected void method_5949(class_1542 pItemEntity) {
        class_1799 itemstack = pItemEntity.method_6983();
        if (this.method_5939(itemstack)) {
            int count = itemstack.method_7947();
            if (count > 1) {
                this.dropItemStack(itemstack.method_7971(count - 1));
            }
            this.method_29499(pItemEntity);
            this.method_5673(class_1304.field_6173, itemstack.method_7971(1));
            this.field_6187[class_1304.field_6173.method_5927()] = 2.0f;
            this.method_6103((class_1297)pItemEntity, itemstack.method_7947());
            pItemEntity.method_31472();
            this.ticksSinceEaten = 0;
        }
    }

    private void dropItemStack(class_1799 pStack) {
        class_1542 itementity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), pStack);
        this.method_37908().method_8649((class_1297)itementity);
    }

    protected class_3414 method_5994() {
        return ModSoundEvents.PENGUIN_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return ModSoundEvents.PENGUIN_HURT;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.PENGUIN_DEATH;
    }

    private boolean babyIsNearAdult() {
        Iterator iterator;
        if (this.method_6109() && (iterator = this.method_37908().method_18467(Penguin.class, this.method_5829().method_1009(2.0, 5.0, 2.0)).iterator()).hasNext()) {
            Penguin penguin = (Penguin)((Object)iterator.next());
            return !penguin.method_6109();
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && (this.slideAnimationProgress != this.lastSlideAnimationProgress || this.swimAnimationProgress != this.lastSwimAnimationProgress)) {
            this.method_18382();
        }
        this.updateSwimmingAnimation();
        this.updateSlidingAnimation();
    }

    public boolean canSlide() {
        return this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10295) && !this.method_6479() && !this.isPregnant() && this.method_18798().method_37268() > 1.0E-6;
    }

    private void updateSlidingAnimation() {
        this.lastSlideAnimationProgress = this.slideAnimationProgress;
        this.slideAnimationProgress = this.canSlide() ? Math.min(1.0f, this.slideAnimationProgress + 0.15f) : Math.max(0.0f, this.slideAnimationProgress - 0.15f);
    }

    public float getSlidingAnimationProgress(float ticks) {
        return class_3532.method_16439((float)ticks, (float)this.lastSlideAnimationProgress, (float)this.slideAnimationProgress);
    }

    private void updateSwimmingAnimation() {
        this.lastSwimAnimationProgress = this.swimAnimationProgress;
        this.swimAnimationProgress = this.method_5799() ? Math.min(1.0f, this.swimAnimationProgress + 0.15f) : Math.max(0.0f, this.swimAnimationProgress - 0.15f);
    }

    public float getSwimmingAnimationProgress(float ticks) {
        return class_3532.method_16439((float)ticks, (float)this.lastSwimAnimationProgress, (float)this.swimAnimationProgress);
    }

    public void method_5958() {
        if (this.swimAnimationProgress > 0.0f) {
            this.method_18380(class_4050.field_18079);
        } else if (this.slideAnimationProgress > 0.0f) {
            this.method_18380(class_4050.field_18081);
        } else {
            this.method_18380(class_4050.field_18076);
        }
    }

    public int method_5986() {
        return 40;
    }

    static class PenguinLookControl
    extends class_1333 {
        private final int maxYRotFromCenter;

        public PenguinLookControl(class_1308 mob, int maxYRotFromCenter) {
            super(mob);
            this.maxYRotFromCenter = maxYRotFromCenter;
        }

        public void method_6231() {
            if (this.field_35103 > 0) {
                --this.field_35103;
                this.method_20251().ifPresent(yHeadRot -> {
                    this.field_6361.field_6241 = this.method_6229(this.field_6361.field_6241, yHeadRot.floatValue(), this.field_6359);
                });
                this.method_20250().ifPresent(xRot -> this.field_6361.method_36457(this.method_6229(this.field_6361.method_36455(), xRot.floatValue(), this.field_6358)));
            } else {
                if (this.field_6361.method_5942().method_6357()) {
                    this.field_6361.method_36457(this.method_6229(this.field_6361.method_36455(), 0.0f, 5.0f));
                }
                this.field_6361.field_6241 = this.method_6229(this.field_6361.field_6241, this.field_6361.field_6283, this.field_6359);
            }
            float f = class_3532.method_15393((float)(this.field_6361.field_6241 - this.field_6361.field_6283));
            if (f < (float)(-this.maxYRotFromCenter)) {
                this.field_6361.field_6283 -= 4.0f;
            } else if (f > (float)this.maxYRotFromCenter) {
                this.field_6361.field_6283 += 4.0f;
            }
        }
    }

    static class PenguinSearchForItemsGoal
    extends class_1352 {
        private final Penguin penguin;

        public PenguinSearchForItemsGoal(Penguin penguin) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.penguin = penguin;
        }

        public boolean method_6264() {
            if (!this.penguin.method_6118(class_1304.field_6173).method_7960() || this.penguin.method_6109() || this.penguin.isPregnant()) {
                return false;
            }
            List list = this.penguin.method_37908().method_8390(class_1542.class, this.penguin.method_5829().method_1009(8.0, 8.0, 8.0), itemEntity -> itemEntity.method_6983().method_31573(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            return !list.isEmpty() && this.penguin.method_6118(class_1304.field_6173).method_7960();
        }

        public void method_6268() {
            List list = this.penguin.method_37908().method_8390(class_1542.class, this.penguin.method_5829().method_1009(8.0, 8.0, 8.0), itemEntity -> itemEntity.method_6983().method_31573(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            class_1799 itemstack = this.penguin.method_6118(class_1304.field_6173);
            if (itemstack.method_7960() && !list.isEmpty()) {
                this.penguin.method_5942().method_6335((class_1297)list.get(0), 1.0);
            }
        }

        public void method_6269() {
            List list = this.penguin.method_37908().method_8390(class_1542.class, this.penguin.method_5829().method_1009(8.0, 8.0, 8.0), itemEntity -> itemEntity.method_6983().method_31573(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            if (!list.isEmpty()) {
                this.penguin.method_5942().method_6335((class_1297)list.get(0), 1.0);
            }
        }
    }

    static class PenguinMeleeAttackGoal
    extends class_1366 {
        private final Penguin penguin;

        public PenguinMeleeAttackGoal(Penguin pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((class_1314)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.penguin = pMob;
        }

        public boolean method_6264() {
            if (!this.penguin.method_6118(class_1304.field_6173).method_7960() || this.penguin.method_6109() || this.penguin.isPregnant()) {
                return false;
            }
            return super.method_6264();
        }
    }

    static class PenguinRandomSwimmingGoal
    extends class_1378 {
        private final Penguin penguin;

        public PenguinRandomSwimmingGoal(Penguin pMob, double pSpeedModifier, int pInterval) {
            super((class_1314)pMob, pSpeedModifier, pInterval);
            this.penguin = pMob;
        }

        public boolean method_6264() {
            if (this.penguin.method_6109() || this.penguin.isPregnant() || !this.penguin.method_6047().method_7960()) {
                return false;
            }
            return super.method_6264();
        }
    }

    static class PenguinAttackTargetGoal<T extends class_1309>
    extends class_1400<T> {
        private final Penguin penguin;

        public PenguinAttackTargetGoal(Penguin pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<class_1309> pPredicate) {
            super((class_1308)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pPredicate);
            this.penguin = pMob;
        }

        public boolean method_6264() {
            if (this.penguin.method_6109() || this.penguin.isPregnant() || !this.penguin.method_6047().method_7960()) {
                return false;
            }
            return super.method_6264();
        }
    }

    static class PenguinPathNavigation
    extends class_1412 {
        public PenguinPathNavigation(Penguin penguin, class_1937 level) {
            super((class_1308)penguin, level);
        }

        protected boolean method_6358() {
            return true;
        }

        protected class_13 method_6336(int p_149222_) {
            this.field_6678 = new class_15(false);
            return new class_13(this.field_6678, p_149222_);
        }

        public boolean method_6333(class_2338 p_149224_) {
            return !this.field_6677.method_8320(p_149224_.method_10074()).method_26215();
        }
    }
}

