/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt;

import com.mojang.logging.LogUtils;
import io.github.discusser.moretnt.objects.MoreTNTObject;
import io.github.discusser.moretnt.objects.PrimedTNTObject;
import io.github.discusser.moretnt.objects.blocks.BaseTNTBlock;
import io.github.discusser.moretnt.objects.entities.BasePrimedTNT;
import io.github.discusser.moretnt.objects.registration.MoreTNTBlocks;
import io.github.discusser.moretnt.objects.registration.MoreTNTEntities;
import io.github.discusser.moretnt.objects.registration.MoreTNTItems;
import io.github.discusser.moretnt.objects.registration.MoreTNTObjects;
import io.github.discusser.moretnt.objects.registration.MoreTNTSounds;
import io.github.discusser.moretnt.objects.registration.MoreTNTTabs;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="moretnt")
public class MoreTNT {
    public static final String MODID = "moretnt";
    public static final String MOD_VERSION = "1.1.3";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final HashMap<BaseTNTBlock, PrimedTNTObject> blockToPrimedTNTMap = new HashMap();
    public static final HashMap<EntityType<? extends BasePrimedTNT>, BaseTNTBlock> entityTypeToBlockMap = new HashMap();

    public MoreTNT(IEventBus modEventBus, ModContainer modContainer) {
        MoreTNTBlocks.BLOCKS.register(modEventBus);
        MoreTNTItems.ITEMS.register(modEventBus);
        MoreTNTEntities.ENTITY_TYPES.register(modEventBus);
        MoreTNTSounds.SOUND_EVENTS.register(modEventBus);
        MoreTNTTabs.TABS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        for (MoreTNTObject object : MoreTNTObjects.objects) {
            blockToPrimedTNTMap.put((BaseTNTBlock)object.blockItem().block().get(), object.primedTNTObject());
            entityTypeToBlockMap.put((EntityType<? extends BasePrimedTNT>)((EntityType)object.primedTNTObject().entityType.get()), (BaseTNTBlock)object.blockItem().block().get());
            BaseTNTBlock block = (BaseTNTBlock)object.blockItem().block().get();
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)object.blockItem().item().get()), (DispenseItemBehavior)this.dispenserExecute((level, blockPos, stack) -> block.createPrimedFromStack(level, stack, blockPos, block.size, block.fire)));
        }
    }

    public DefaultDispenseItemBehavior dispenserExecute(final DispenserConsumer function) {
        return new DefaultDispenseItemBehavior(this){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource pSource, @NotNull ItemStack pStack) {
                ServerLevel level = pSource.level();
                BlockPos blockpos = pSource.pos().relative((Direction)pSource.state().getValue((Property)DispenserBlock.FACING));
                BasePrimedTNT instance = function.createPrimed((Level)level, blockpos, pStack);
                level.addFreshEntity((Entity)instance);
                level.playSound(null, instance.getX(), instance.getY(), instance.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                pStack.shrink(1);
                return pStack;
            }
        };
    }

    public static interface DispenserConsumer {
        public BasePrimedTNT createPrimed(Level var1, BlockPos var2, ItemStack var3);
    }
}

