/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.discusser.moretnt.objects.blocks.BaseTNTBlock;
import io.github.discusser.moretnt.objects.entities.BasePrimedTNT;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BaseTNTRenderer
extends EntityRenderer<BasePrimedTNT> {
    public final BlockRenderDispatcher blockRenderer;
    public final BaseTNTBlock block;

    public BaseTNTRenderer(EntityRendererProvider.Context pContext, BaseTNTBlock block) {
        super(pContext);
        this.shadowRadius = 0.5f;
        this.blockRenderer = pContext.getBlockRenderDispatcher();
        this.block = block;
    }

    public void render(BasePrimedTNT pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, 0.5f, 0.0f);
        int i = pEntity.getFuse();
        if ((float)i - pPartialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)i - pPartialTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            pPoseStack.scale(f1, f1, f1);
        }
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        pPoseStack.translate(-0.5f, -0.5f, 0.5f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)((BlockState)this.block.defaultBlockState().setValue((Property)BaseTNTBlock.FACING, (Comparable)pEntity.facing)), (PoseStack)pPoseStack, (MultiBufferSource)pBuffer, (int)pPackedLight, (i / 5 % 2 == 0 ? 1 : 0) != 0);
        pPoseStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    @Deprecated
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BasePrimedTNT pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

