/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.data;

import io.github.discusser.moretnt.data.MoreTNTDataProviders;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="moretnt", bus=EventBusSubscriber.Bus.MOD)
public class DataEventHandler {
    public static <T extends DataProvider> void registerClient(GatherDataEvent event, DataProvider.Factory<T> factory) {
        event.getGenerator().addProvider(event.includeClient(), factory);
    }

    public static <T extends DataProvider> void registerServer(GatherDataEvent event, DataProvider.Factory<T> factory) {
        event.getGenerator().addProvider(event.includeServer(), factory);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper efh = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DataEventHandler.registerClient(event, pOutput -> new MoreTNTDataProviders.BlockStates(pOutput, "moretnt", efh));
        DataEventHandler.registerServer(event, pOutput -> new MoreTNTDataProviders.Recipes(pOutput, lookupProvider));
        DataEventHandler.registerServer(event, pOutput -> new MoreTNTDataProviders.LootTables(pOutput, lookupProvider));
        DataEventHandler.registerServer(event, pOutput -> new MoreTNTDataProviders.BlockTags(pOutput, lookupProvider, "moretnt", efh));
    }
}

