/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.data;

import io.github.discusser.moretnt.MoreTNT;
import io.github.discusser.moretnt.data.MoreTNTLootTables;
import io.github.discusser.moretnt.objects.MoreTNTBlockItem;
import io.github.discusser.moretnt.objects.blocks.BaseTNTBlock;
import io.github.discusser.moretnt.objects.registration.MoreTNTBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreTNTDataProviders {

    public static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
            super(output, modid, exFileHelper);
        }

        public ModelFile tnt(String name) {
            String texture = "block/" + name;
            return this.models().cubeBottomTop(name, this.modLoc(texture + "_side"), this.modLoc(texture + "_bottom"), this.modLoc(texture + "_top"));
        }

        public ModelFile tnt4x(String baseName) {
            String texture = "block/" + baseName;
            String name = baseName + "_4x";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/tnt_4x"))).texture("bottom", texture + "_bottom")).texture("side", texture + "_side")).texture("top", texture + "_top")).texture("particle", texture + "_side")).texture("overlay_top", "block/overlay/4x_overlay");
        }

        public void simpleBlockState(Block block, ModelFile modelFile) {
            this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile(modelFile).build());
        }

        public void tntOrientableBlockState(BaseTNTBlock block, ModelFile modelFile) {
            this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(modelFile).rotationY((int)((Direction)state.getValue((Property)BaseTNTBlock.FACING)).getOpposite().toYRot()).build());
        }

        public void simpleItemModel(String name) {
            this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
        }

        protected void registerStatesAndModels() {
            MoreTNTBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> {
                Block block = (Block)blockRegistryObject.get();
                if (blockRegistryObject.getKey() != null) {
                    String name = blockRegistryObject.getKey().location().getPath();
                    if (block instanceof BaseTNTBlock) {
                        boolean is4x = name.endsWith("4x");
                        if (is4x) {
                            this.tntOrientableBlockState((BaseTNTBlock)block, this.tnt4x(name.replace("_4x", "")));
                        } else {
                            this.simpleBlockState(block, this.tnt(name));
                        }
                    } else {
                        this.simpleBlockState(block, this.cubeAll(block));
                    }
                    this.simpleItemModel(name);
                }
            });
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
            super(pOutput, pRegistries);
        }

        public ShapedRecipeBuilder shapedRecipeBuilder(ItemLike output, ItemLike inputCondition) {
            return this.shapedRecipeBuilder(output, inputCondition, 1);
        }

        public ShapedRecipeBuilder shapedRecipeBuilder(ItemLike output, ItemLike inputCondition, int count) {
            return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{inputCondition}));
        }

        public ShapelessRecipeBuilder shapelessRecipeBuilder(ItemLike output, ItemLike inputCondition) {
            return this.shapelessRecipeBuilder(output, inputCondition, 1);
        }

        public ShapelessRecipeBuilder shapelessRecipeBuilder(ItemLike output, ItemLike inputCondition, int count) {
            return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{inputCondition}));
        }

        public ShapedRecipeBuilder tntShapedRecipeBuilder(MoreTNTBlockItem<?> output) {
            return this.shapedRecipeBuilder((ItemLike)output.item().get(), (ItemLike)Items.TNT);
        }

        public ShapedRecipeBuilder tntSurround(MoreTNTBlockItem<?> output, ItemLike surrounding) {
            return this.tntSurround(output, surrounding, (ItemLike)Items.TNT);
        }

        public ShapedRecipeBuilder tntSurround(MoreTNTBlockItem<?> output, ItemLike surrounding, ItemLike surrounded) {
            return this.tntShapedRecipeBuilder(output).pattern("AAA").pattern("ATA").pattern("AAA").define(Character.valueOf('A'), surrounding).define(Character.valueOf('T'), surrounded);
        }

        public ShapedRecipeBuilder packNine(ItemLike output, ItemLike input) {
            return this.shapedRecipeBuilder(output, input, 1).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), input);
        }

        public ShapedRecipeBuilder packFour(ItemLike output, ItemLike input) {
            return this.shapedRecipeBuilder(output, input, 1).pattern("AA").pattern("AA").define(Character.valueOf('A'), input);
        }

        public ShapelessRecipeBuilder unpackNine(ItemLike output, ItemLike input) {
            return this.shapelessRecipeBuilder(output, input, 9).requires(input);
        }

        public ShapelessRecipeBuilder unpackFour(ItemLike output, ItemLike input) {
            return this.shapelessRecipeBuilder(output, input, 4).requires(input);
        }

        public ResourceLocation packRecipeId(String prefix, ItemLike output) {
            return ResourceLocation.fromNamespaceAndPath((String)"moretnt", (String)(prefix + "_into_" + RecipeBuilder.getDefaultRecipeId((ItemLike)output).getPath()));
        }

        public void packUnpackFour(ItemLike packed, ItemLike unpacked, RecipeOutput pRecipeOutput) {
            this.packFour(packed, unpacked).save(pRecipeOutput, this.packRecipeId("pack_four", packed));
            this.unpackFour(unpacked, packed).save(pRecipeOutput, this.packRecipeId("unpack_four", unpacked));
        }

        public void packUnpackNine(ItemLike packed, ItemLike unpacked, RecipeOutput pRecipeOutput) {
            this.packNine(packed, unpacked).save(pRecipeOutput, this.packRecipeId("pack_nine", packed));
            this.unpackNine(unpacked, packed).save(pRecipeOutput, this.packRecipeId("unpack_nine", unpacked));
        }

        protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
            this.packUnpackNine((ItemLike)MoreTNTBlocks.COMPRESSED_SAND.block().get(), (ItemLike)Items.SAND, pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.DOME_TNT, (ItemLike)MoreTNTBlocks.COMPRESSED_SAND.item().get()).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.FIRE_TNT, (ItemLike)Items.FIRE_CHARGE).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.KNOCKBACK_TNT, (ItemLike)Items.FEATHER).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.LAVA_TNT, (ItemLike)Items.LAVA_BUCKET).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.NEGATIVE_TNT, (ItemLike)Items.AMETHYST_SHARD).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.SHUFFLE_TNT, (ItemLike)Items.CHORUS_FRUIT).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.SNOW_TNT, (ItemLike)Items.SNOW_BLOCK).save(pRecipeOutput);
            this.tntSurround(MoreTNTBlocks.WATER_TNT, (ItemLike)Items.WATER_BUCKET).save(pRecipeOutput);
            this.tntShapedRecipeBuilder(MoreTNTBlocks.COBBLESTONE_TNT).pattern("W L").pattern("WTL").pattern("W L").define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('T'), (ItemLike)Items.TNT).save(pRecipeOutput);
            this.tntShapedRecipeBuilder(MoreTNTBlocks.STONE_TNT).pattern("L").pattern("T").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('T'), (ItemLike)MoreTNTBlocks.WATER_TNT.item().get()).save(pRecipeOutput);
            this.tntShapedRecipeBuilder(MoreTNTBlocks.OBSIDIAN_TNT).pattern("W").pattern("T").define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('T'), (ItemLike)MoreTNTBlocks.LAVA_TNT.item().get()).save(pRecipeOutput);
            MoreTNTBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> {
                if (blockRegistryObject.getKey() != null) {
                    String blockPath = blockRegistryObject.getKey().location().getPath();
                    if (blockPath.endsWith("_4x")) {
                        ResourceLocation unpackedBlockLocation = ResourceLocation.fromNamespaceAndPath((String)"moretnt", (String)blockPath.replace("_4x", ""));
                        Block unpackedBlock = (Block)BuiltInRegistries.BLOCK.get(unpackedBlockLocation);
                        if (unpackedBlock != Blocks.AIR) {
                            this.packUnpackFour((ItemLike)blockRegistryObject.get(), (ItemLike)unpackedBlock, pRecipeOutput);
                        } else {
                            MoreTNT.LOGGER.warn("Could not create recipes for block '" + String.valueOf(blockRegistryObject) + "' because there is no block that matches '" + String.valueOf(unpackedBlockLocation) + "'");
                        }
                    }
                } else {
                    MoreTNT.LOGGER.warn("Could not create recipes for block '" + String.valueOf(blockRegistryObject) + "' because key is null");
                }
            });
        }
    }

    public static class LootTables
    extends LootTableProvider {
        public LootTables(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
            super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MoreTNTLootTables::new, LootContextParamSets.BLOCK)), pRegistries);
        }
    }

    public static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, modId, existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(net.minecraft.tags.BlockTags.MINEABLE_WITH_SHOVEL).add((Object)((Block)MoreTNTBlocks.COMPRESSED_SAND.block().get()));
        }
    }
}

