/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.explosions;

import io.github.discusser.moretnt.objects.registration.MoreTNTBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.compress.utils.Sets;

public class BaseExplosion
extends Explosion {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    public final Explosion.BlockInteraction blockInteraction;
    public final boolean fire;
    public final Level level;
    public final double x;
    public final double y;
    public final double z;
    @Nullable
    public final Entity source;
    public final float radius;
    public final ExplosionDamageCalculator damageCalculator;
    public final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    public final List<BlockPos> neighborTnt = new ArrayList<BlockPos>();
    public final Map<Entity, Vec3> entitiesInRange = new HashMap<Entity, Vec3>();
    public final SoundEvent soundEvent;
    public final ParticleOptions pSmallExplosionParticles;
    public final ParticleOptions pLargeExplosionParticles;

    public BaseExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pX, double pY, double pZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction, ParticleOptions pSmallExplosionParticles, ParticleOptions pLargeExplosionParticles, Holder<SoundEvent> pExplosionSound) {
        super(pLevel, pSource, pDamageSource, pDamageCalculator, pX, pY, pZ, pRadius, pFire, pBlockInteraction, pSmallExplosionParticles, pLargeExplosionParticles, pExplosionSound);
        this.level = pLevel;
        this.source = pSource;
        this.radius = pRadius;
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.fire = pFire;
        this.blockInteraction = pBlockInteraction;
        this.damageCalculator = pDamageCalculator == null ? this.makeDamageCalculator(pSource) : pDamageCalculator;
        this.soundEvent = (SoundEvent)pExplosionSound.value();
        this.pSmallExplosionParticles = pSmallExplosionParticles;
        this.pLargeExplosionParticles = pLargeExplosionParticles;
    }

    public ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity pEntity) {
        return pEntity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(pEntity);
    }

    void onBlockExploded(Set<BlockPos> set, BlockPos blockpos, int j, int k, int l) {
        set.add(blockpos);
    }

    void onExplosionIteration(Set<BlockPos> set, BlockPos blockpos, int j, int k, int l) {
    }

    boolean canBlockExplode(BlockPos blockpos) {
        return true;
    }

    public void explode() {
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet((Object[])new BlockPos[0]);
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.getBlockState(blockpos);
                        FluidState fluidstate = this.level.getFluidState(blockpos);
                        if (!this.level.isInWorldBounds(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f) && !MoreTNTBlocks.isTNT(blockstate)) {
                            this.onBlockExploded(set, blockpos, j, k, l);
                        }
                        this.onExplosionIteration(set, blockpos, j, k, l);
                        if (MoreTNTBlocks.isTNT(blockstate)) {
                            this.neighborTnt.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.floor((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.floor((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.floor((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.floor((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.floor((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.floor((double)(this.z + (double)f2 + 1.0));
        List list = this.level.getEntities(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            Player player;
            double d10;
            double d9;
            double d7;
            double d5;
            double d12;
            double d11;
            if (entity.ignoreExplosion((Explosion)this) || !((d11 = Math.sqrt(entity.distanceToSqr(vec3)) / (double)f2) <= 1.0) || (d12 = Math.sqrt((d5 = entity.getX() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y) * d7 + (d9 = entity.getZ() - this.z) * d9)) == 0.0) continue;
            d5 /= d12;
            d7 /= d12;
            d9 /= d12;
            double d13 = (1.0 - d11) * (double)BaseExplosion.getSeenPercent((Vec3)vec3, (Entity)entity) * (double)this.damageCalculator.getKnockbackMultiplier(entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d10 = d13 * (1.0 - livingentity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d10 = d13;
            }
            Vec3 vec31 = new Vec3(d5 *= d10, d7 *= d10, d9 *= d10);
            vec31 = EventHooks.getExplosionKnockback((Level)this.level, (Explosion)this, (Entity)entity, (Vec3)vec31);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec31));
            if (!(!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying)) {
                this.entitiesInRange.put((Entity)player, vec31);
            }
            entity.onExplosionHit(this.source);
        }
    }

    public void preFinalizeExplosion(boolean pSpawnParticles, SoundEvent soundEvent) {
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, soundEvent, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        if (pSpawnParticles) {
            if (!(this.radius < 2.0f)) {
                this.level.addParticle(this.pLargeExplosionParticles, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.addParticle(this.pSmallExplosionParticles, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        Util.shuffle(this.toBlow, (RandomSource)this.level.random);
    }

    public void postFinalizeExplosion() {
        for (BlockPos blockpos : this.neighborTnt) {
            if (!(this.level instanceof ServerLevel)) continue;
            this.level.getBlockState(blockpos).onBlockExploded(this.level, blockpos, (Explosion)this);
        }
    }

    public void finalizeExplosion(boolean pSpawnParticles) {
        this.preFinalizeExplosion(pSpawnParticles, this.soundEvent);
        this.onFinalizeExplosion(pSpawnParticles);
        this.postFinalizeExplosion();
    }

    public void onFinalizeExplosion(boolean pSpawnParticles) {
    }
}

