/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.explosions;

import io.github.discusser.moretnt.explosions.BaseExplosion;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ShuffleExplosion
extends BaseExplosion {
    public ShuffleExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pX, double pY, double pZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction, ParticleOptions pSmallExplosionParticles, ParticleOptions pLargeExplosionParticles, Holder<SoundEvent> pExplosionSound) {
        super(pLevel, pSource, pDamageSource, pDamageCalculator, pX, pY, pZ, pRadius, pFire, pBlockInteraction, pSmallExplosionParticles, pLargeExplosionParticles, pExplosionSound);
    }

    @Override
    void onBlockExploded(Set<BlockPos> set, BlockPos blockpos, int j, int k, int l) {
        if (!this.level.getBlockState(blockpos).isAir()) {
            set.add(blockpos);
        }
    }

    @Override
    public void onFinalizeExplosion(boolean pSpawnParticles) {
        ObjectArrayList toSwap = new ObjectArrayList((ObjectList)this.toBlow);
        if (this.level instanceof ServerLevel) {
            for (BlockPos pos : this.toBlow) {
                int i = this.level.random.nextInt(toSwap.size());
                BlockPos randomPos = (BlockPos)toSwap.remove(i);
                BlockState blockState = this.level.getBlockState(pos);
                BlockState randomBlockState = this.level.getBlockState(randomPos);
                blockState.onBlockExploded(this.level, pos, (Explosion)this);
                randomBlockState.onBlockExploded(this.level, randomPos, (Explosion)this);
                this.level.setBlockAndUpdate(randomPos, blockState);
                this.level.setBlockAndUpdate(pos, randomBlockState);
            }
        }
    }
}

