/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.explosions;

import io.github.discusser.moretnt.explosions.BaseExplosion;
import io.github.discusser.moretnt.objects.registration.MoreTNTBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class SphereExplosion
extends BaseExplosion {
    public final Block toPlace;
    public final boolean filled;

    public SphereExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pX, double pY, double pZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction, ParticleOptions pSmallExplosionParticles, ParticleOptions pLargeExplosionParticles, Holder<SoundEvent> pExplosionSound, Block toPlace, boolean filled) {
        super(pLevel, pSource, pDamageSource, pDamageCalculator, pX, pY, pZ, pRadius, pFire, pBlockInteraction, pSmallExplosionParticles, pLargeExplosionParticles, pExplosionSound);
        this.toPlace = toPlace;
        this.filled = filled;
    }

    public SphereExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pX, double pY, double pZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction, ParticleOptions pSmallExplosionParticles, ParticleOptions pLargeExplosionParticles, Holder<SoundEvent> pExplosionSound, Block toPlace) {
        super(pLevel, pSource, pDamageSource, pDamageCalculator, pX, pY, pZ, pRadius, pFire, pBlockInteraction, pSmallExplosionParticles, pLargeExplosionParticles, pExplosionSound);
        this.toPlace = toPlace;
        this.filled = true;
    }

    public double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public void addBlock(BlockPos blockPos) {
        if (MoreTNTBlocks.isTNT(this.level.getBlockState(blockPos))) {
            this.neighborTnt.add(blockPos);
        } else {
            this.toBlow.add((Object)blockPos);
        }
    }

    @Override
    public void explode() {
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        double radiusX = (double)this.radius + 0.5;
        double radiusY = (double)this.radius + 0.5;
        double radiusZ = (double)this.radius + 0.5;
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = this.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!this.filled && this.lengthSq(nextXn, yn, zn) <= 1.0 && this.lengthSq(xn, nextYn, zn) <= 1.0 && this.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    this.addBlock(BlockPos.containing((double)(this.x + (double)x), (double)(this.y + (double)y), (double)(this.z + (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x - (double)x), (double)(this.y + (double)y), (double)(this.z + (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x + (double)x), (double)(this.y - (double)y), (double)(this.z + (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x + (double)x), (double)(this.y + (double)y), (double)(this.z - (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x - (double)x), (double)(this.y - (double)y), (double)(this.z + (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x + (double)x), (double)(this.y - (double)y), (double)(this.z - (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x - (double)x), (double)(this.y + (double)y), (double)(this.z - (double)z)));
                    this.addBlock(BlockPos.containing((double)(this.x - (double)x), (double)(this.y - (double)y), (double)(this.z - (double)z)));
                }
            }
        }
        float f2 = this.radius * 2.0f;
        ArrayList list = new ArrayList();
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, list, (double)f2);
    }

    @Override
    public void onFinalizeExplosion(boolean pSpawnParticles) {
        for (BlockPos blockPos : this.toBlow) {
            BlockState blockState;
            if (!(this.level instanceof ServerLevel) || !(blockState = this.level.getBlockState(blockPos)).isAir() && blockState.getFluidState().isEmpty() && !blockState.canBeReplaced()) continue;
            this.level.setBlockAndUpdate(blockPos, this.toPlace.defaultBlockState());
        }
    }
}

