/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.objects.blocks;

import io.github.discusser.moretnt.MoreTNT;
import io.github.discusser.moretnt.network.ClientboundEntityFacingPacket;
import io.github.discusser.moretnt.objects.blocks.ITNTBlock;
import io.github.discusser.moretnt.objects.entities.BasePrimedTNT;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseTNTBlock
extends TntBlock
implements ITNTBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public float size = 4.0f;
    public boolean fire = true;

    public BaseTNTBlock() {
        super(Blocks.TNT.properties());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BaseTNTBlock(float size, boolean fire) {
        this();
        this.size = size;
        this.fire = fire;
    }

    public void onCaughtFire(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!world.isClientSide) {
            BasePrimedTNT tnt = this.createPrimed(world, pos, this.size, this.fire);
            world.addFreshEntity((Entity)tnt);
            this.sendEntityFacingPacket(tnt);
            world.playSound(null, tnt.getX(), tnt.getY(), tnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)igniter, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide) {
            BasePrimedTNT tnt = this.createPrimed(level, pos, this.size, this.fire);
            int i = tnt.getFuse();
            tnt.setFuse((short)(level.random.nextInt(i / 4) + i / 8));
            level.addFreshEntity((Entity)tnt);
            this.sendEntityFacingPacket(tnt);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void wasExploded(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Explosion pExplosion) {
    }

    public void sendEntityFacingPacket(BasePrimedTNT entity) {
        ClientboundEntityFacingPacket packet = new ClientboundEntityFacingPacket(entity.getId(), entity.facing);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull LevelAccessor level, @NotNull BlockPos pos, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    public Direction getFacing(Level level, BlockPos blockPos) {
        return level.getBlockState(blockPos).getOptionalValue((Property)FACING).orElse(BasePrimedTNT.DEFAULT_DIRECTION);
    }

    @Override
    public BasePrimedTNT createPrimed(Level level, BlockPos blockPos, float size, boolean fire) {
        Block block = level.getBlockState(blockPos).getBlock();
        if (block instanceof BaseTNTBlock) {
            return this.createPrimed((EntityType<? extends PrimedTnt>)((EntityType)MoreTNT.blockToPrimedTNTMap.get((Object)block).entityType.get()), (BaseTNTBlock)block, level, blockPos, size, fire);
        }
        throw new RuntimeException("Tried to create a primed TNT from a block of type '" + block.getClass().getCanonicalName() + "' that does not extend '" + BaseTNTBlock.class.getCanonicalName() + "'");
    }

    @Override
    public BasePrimedTNT createPrimedFromStack(Level level, ItemStack stack, BlockPos blockPos, float size, boolean fire) {
        Block block = Block.byItem((Item)stack.getItem());
        if (block instanceof BaseTNTBlock) {
            return this.createPrimed((EntityType<? extends PrimedTnt>)((EntityType)MoreTNT.blockToPrimedTNTMap.get((Object)block).entityType.get()), (BaseTNTBlock)block, level, blockPos, size, fire);
        }
        throw new RuntimeException("Tried to create a primed TNT from an item of type '" + stack.getItem().getClass().getCanonicalName() + "' that does not extend '" + BaseTNTBlock.class.getCanonicalName() + "'");
    }

    private BasePrimedTNT createPrimed(EntityType<? extends PrimedTnt> type, BaseTNTBlock block, Level level, BlockPos blockPos, float size, boolean fire) {
        return new BasePrimedTNT(type, block, level, (double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, size, fire, this.getFacing(level, blockPos));
    }
}

