/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.moretnt.objects.entities;

import io.github.discusser.moretnt.MoreTNT;
import io.github.discusser.moretnt.explosions.BaseExplosion;
import io.github.discusser.moretnt.network.CustomClientboundExplodePacket;
import io.github.discusser.moretnt.objects.PrimedTNTObject;
import io.github.discusser.moretnt.objects.blocks.BaseTNTBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class BasePrimedTNT
extends PrimedTnt {
    public static final float DEFAULT_SIZE = 4.0f;
    public static final boolean DEFAULT_FIRE = true;
    public static final Direction DEFAULT_DIRECTION = Direction.NORTH;
    public Direction facing;
    public float size;
    public boolean fire;
    public BaseTNTBlock block;

    public BasePrimedTNT(EntityType<? extends PrimedTnt> pEntityType, Level pLevel) {
        this(pEntityType, MoreTNT.entityTypeToBlockMap.get(pEntityType), pLevel, 0.0, 0.0, 0.0, MoreTNT.entityTypeToBlockMap.get(pEntityType).size, MoreTNT.entityTypeToBlockMap.get(pEntityType).fire, DEFAULT_DIRECTION);
    }

    public BasePrimedTNT(EntityType<? extends PrimedTnt> entityType, BaseTNTBlock block, Level pLevel, double pX, double pY, double pZ, float size, boolean fire, Direction facing) {
        super(entityType, pLevel);
        this.setPos(pX, pY, pZ);
        double d0 = pLevel.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.block = block;
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
        this.size = size;
        this.fire = fire;
        this.facing = facing;
    }

    protected void explode() {
        double pZ;
        double pY;
        double pX = this.getX();
        BaseExplosion explosion = this.createExplosion(pX, pY = this.getY(0.0625), pZ = this.getZ());
        if (explosion == null) {
            return;
        }
        if (EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion)) {
            return;
        }
        explosion.explode();
        explosion.finalizeExplosion(true);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (ServerPlayer serverplayer : level2.players()) {
                if (!(serverplayer.distanceToSqr(pX, pY, pZ) < 4096.0)) continue;
                CustomClientboundExplodePacket packet = new CustomClientboundExplodePacket(pX, pY, pZ, this.size, explosion.getToBlow(), explosion.getHitPlayers().getOrDefault(serverplayer, new Vec3(0.0, 0.0, 0.0)), explosion.soundEvent.getLocation());
                PacketDistributor.sendToPlayer((ServerPlayer)serverplayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public BaseExplosion createExplosion(double x, double y, double z) {
        if (this.block == null) {
            return null;
        }
        PrimedTNTObject primedTNTObject = MoreTNT.blockToPrimedTNTMap.get(this.block);
        return primedTNTObject.explosionFactory.create(this.level(), null, null, null, x, y, z, this.size, this.fire, Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, primedTNTObject.sound);
    }
}

