/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility;

import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.discord.DiscordRPC;
import io.github.kurrycat.mpkmod.events.Event;
import io.github.kurrycat.mpkmod.events.EventAPI;
import io.github.kurrycat.mpkmod.events.OnKeyInputEvent;
import io.github.kurrycat.mpkmod.events.OnKeybindEvent;
import io.github.kurrycat.mpkmod.events.OnMouseInputEvent;
import io.github.kurrycat.mpkmod.events.OnPluginMessageEvent;
import io.github.kurrycat.mpkmod.events.OnRenderOverlayEvent;
import io.github.kurrycat.mpkmod.events.OnRenderWorldOverlayEvent;
import io.github.kurrycat.mpkmod.events.OnTickEndEvent;
import io.github.kurrycat.mpkmod.events.OnTickStartEvent;
import io.github.kurrycat.mpkmod.gui.MPKGuiScreen;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.modules.MPKModuleImpl;
import io.github.kurrycat.mpkmod.modules.ModuleFinder;
import io.github.kurrycat.mpkmod.modules.ModuleManager;
import io.github.kurrycat.mpkmod.network.impl.MPKPacketListenerClientImpl;
import io.github.kurrycat.mpkmod.save.Serializer;
import io.github.kurrycat.mpkmod.util.ClassUtil;
import io.github.kurrycat.mpkmod.util.JSONConfig;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Procedure;
import io.github.kurrycat.mpknetapi.common.network.packet.MPKPacket;
import io.github.kurrycat.mpknetapi.common.network.packet.impl.clientbound.MPKPacketListenerClient;
import io.github.kurrycat.mpknetapi.common.network.packet.impl.serverbound.MPKPacketRegister;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class API {
    public static final String MODID = "mpkmod";
    public static final Logger LOGGER = LogManager.getLogger((String)"mpkmod");
    public static final Marker DISCORD_RPC_MARKER = MarkerManager.getMarker((String)"DISCORD_RPC");
    public static final Marker COMPATIBILITY_MARKER = MarkerManager.getMarker((String)"COMPATIBILITY");
    public static final Marker CONFIG_MARKER = MarkerManager.getMarker((String)"CONFIG");
    public static final MPKPacketListenerClient PACKET_LISTENER_CLIENT = new MPKPacketListenerClientImpl();
    public static final String NAME = "MPK Mod";
    public static final String VERSION = "2.0";
    public static final String KEYBINDING_CATEGORY = "mpkmod.key.category";
    public static final String packageName = "io.github.kurrycat.mpkmod";
    public static Instant gameStartedInstant;
    public static long tickTime;
    public static Map<String, MPKGuiScreen> guiScreenMap;
    public static Map<String, Procedure> keyBindingMap;
    public static HashMap<String, Option> optionsMap;
    private static FunctionHolder functionHolder;

    public static void preInit(Class<?> callerClass) {
        ClassUtil.setModClass(callerClass);
        JSONConfig.setupFiles();
        Serializer.registerSerializer();
        optionsMap = Option.createOptionMap();
        Option.updateOptionMapFromJSON(true);
        Main mainModule = new Main();
        ModuleManager.moduleMap.put("main", new MPKModuleImpl("main", mainModule, null));
        mainModule.init();
        ModuleFinder.init();
        ModuleManager.initAllModules();
    }

    public static void registerGUIScreen(String guiID, MPKGuiScreen screen) {
        screen.setID(guiID);
        guiScreenMap.put(guiID, screen);
    }

    public static void registerKeyBinding(String id, Procedure procedure) {
        keyBindingMap.put(id, procedure);
    }

    public static void init(String mcVersion) {
        Minecraft.version = mcVersion;
        gameStartedInstant = Instant.now();
        ModuleManager.loadAllModules();
    }

    public static void registerFunctionHolder(FunctionHolder holder) {
        functionHolder = holder;
    }

    public static <T extends FunctionHolder> T getFunctionHolder() {
        return (T)functionHolder;
    }

    public static <T extends FunctionHolder> Optional<T> getFunctionHolder(Class<T> subClass) {
        return Optional.ofNullable(subClass.isInstance(functionHolder) ? (FunctionHolder)subClass.cast(functionHolder) : null);
    }

    static {
        tickTime = 0L;
        guiScreenMap = new HashMap<String, MPKGuiScreen>();
        keyBindingMap = new HashMap<String, Procedure>();
    }

    public static class Events {
        public static void onTickStart() {
            EventAPI.postEvent(new OnTickStartEvent());
        }

        public static void onTickEnd() {
            EventAPI.postEvent(new OnTickEndEvent());
        }

        public static void onRenderOverlay() {
            EventAPI.postEvent(new OnRenderOverlayEvent());
        }

        public static void onRenderWorldOverlay(float partialTicks) {
            EventAPI.postEvent(new OnRenderWorldOverlayEvent(partialTicks));
        }

        public static void onLoadComplete() {
            guiScreenMap.forEach((id, guiScreen) -> guiScreen.onInit());
        }

        public static void onServerConnect(boolean isLocal) {
            ArrayList modules = new ArrayList();
            ModuleManager.moduleMap.forEach((id, module) -> modules.add(id));
            Minecraft.Interface.get().ifPresent(i -> i.sendPacket(new MPKPacketRegister(API.VERSION, modules)));
            Minecraft.updateWorldState(Event.EventType.SERVER_CONNECT, isLocal);
            if (Main.discordRpcInitialized) {
                DiscordRPC.updateWorldAndPlayState();
            }
        }

        public static void onServerDisconnect() {
            Minecraft.updateWorldState(Event.EventType.SERVER_DISCONNECT, false);
            if (Main.discordRpcInitialized) {
                DiscordRPC.updateWorldAndPlayState();
            }
        }

        public static void onKeyInput(int keyCode, String key, boolean pressed) {
            EventAPI.postEvent(new OnKeyInputEvent(keyCode, key, pressed));
        }

        public static void onMouseInput(Mouse.Button button, Mouse.State state, int x, int y, int dx, int dy, int dwheel, long nanos) {
            EventAPI.postEvent(new OnMouseInputEvent(button, state, x, y, dx, dy, dwheel, nanos));
        }

        public static void onKeybind(String id) {
            Procedure keyBinding;
            MPKGuiScreen guiScreen = guiScreenMap.get(id);
            if (guiScreen != null) {
                guiScreen.onKeybindPressed();
            }
            if ((keyBinding = keyBindingMap.get(id)) != null) {
                keyBinding.run();
            }
            EventAPI.postEvent(new OnKeybindEvent(id));
        }

        public static void onPluginMessage(MPKPacket packet) {
            packet.process(PACKET_LISTENER_CLIENT);
            EventAPI.postEvent(new OnPluginMessageEvent(packet));
        }
    }
}

