/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.MCClasses;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.events.Event;
import io.github.kurrycat.mpkmod.gui.MPKGuiScreen;
import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.ticks.TickInput;
import io.github.kurrycat.mpknetapi.common.network.packet.MPKPacket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Optional;

@InfoString.AccessInstance
public class Minecraft {
    public static String version;
    public static WorldState worldState;
    public static PlayState playState;

    @InfoString.Getter
    public static String getIp() {
        if (Minecraft.isSingleplayer()) {
            return "Singleplayer";
        }
        return Interface.get().map(Interface::getIP).orElseGet(() -> {
            API.LOGGER.info(API.COMPATIBILITY_MARKER, "Failed to get IP, are you playing on an unsupported minecraft version?");
            return "Failed getting IP";
        });
    }

    @InfoString.Getter
    public static boolean isSingleplayer() {
        return worldState == WorldState.SINGLE_PLAYER;
    }

    @InfoString.Getter
    public static String getFps() {
        return Interface.get().map(Interface::getFPS).orElseGet(() -> {
            API.LOGGER.info(API.COMPATIBILITY_MARKER, "Failed to get FPS, are you playing on an unsupported minecraft version?");
            return "Error";
        });
    }

    @InfoString.Getter
    public static String getMcVersion() {
        return version;
    }

    @InfoString.Getter
    public static String getUsername() {
        if (!Interface.get().isPresent()) {
            API.LOGGER.info(API.COMPATIBILITY_MARKER, "Failed to get username, are you playing on an unsupported minecraft version?");
            return "Error";
        }
        return Interface.get().get().getUserName();
    }

    public static String getCurrentGuiScreen() {
        if (!Interface.get().isPresent()) {
            API.LOGGER.info(API.COMPATIBILITY_MARKER, "Failed to get current screen name, are you playing on an unsupported minecraft version?");
            return "Error";
        }
        return Interface.get().get().getCurrentGuiScreen();
    }

    @InfoString.Getter
    public static String getTime() {
        return new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    @InfoString.Getter
    public static String getDate() {
        return new SimpleDateFormat("dd/MM/yy").format(Calendar.getInstance().getTime());
    }

    public static void updateWorldState(Event.EventType type, boolean isLocal) {
        worldState = type == Event.EventType.SERVER_CONNECT ? (isLocal ? WorldState.SINGLE_PLAYER : WorldState.MULTI_PLAYER) : WorldState.MENU;
    }

    public static void displayGuiScreen(MPKGuiScreen screen) {
        Interface.get().ifPresent(i -> i.displayGuiScreen(screen));
    }

    public static void copyToClipboard(String str) {
        Interface.get().ifPresent(i -> i.copyToClipboard(str));
    }

    public static boolean setInputs(TickInput inputs) {
        return Minecraft.setInputs(Float.valueOf(inputs.getYaw()), true, Float.valueOf(inputs.getPitch()), true, inputs.getKeyInputs(), ~inputs.getKeyInputs(), inputs.getL(), inputs.getR());
    }

    public static boolean setInputs(Float yaw, boolean relYaw, Float pitch, boolean relPitch, int pressedInputs, int releasedInputs, int L, int R) {
        if (!Minecraft.isSingleplayer()) {
            return false;
        }
        if (!Interface.get().isPresent()) {
            API.LOGGER.info(API.COMPATIBILITY_MARKER, "Failed to set inputs, are you playing on an unsupported minecraft version?");
            return false;
        }
        return Interface.get().get().setInputs(yaw, relYaw, pitch, relPitch, pressedInputs, releasedInputs, L, R);
    }

    public static boolean isF3Enabled() {
        return Interface.get().map(Interface::isF3Enabled).orElse(false);
    }

    static {
        worldState = WorldState.MENU;
        playState = PlayState.ACTIVE;
    }

    public static interface Interface
    extends FunctionHolder {
        public static Optional<Interface> get() {
            return API.getFunctionHolder(Interface.class);
        }

        public String getIP();

        public String getFPS();

        public void displayGuiScreen(MPKGuiScreen var1);

        public String getCurrentGuiScreen();

        public String getUserName();

        public void copyToClipboard(String var1);

        public boolean setInputs(Float var1, boolean var2, Float var3, boolean var4, int var5, int var6, int var7, int var8);

        public boolean isF3Enabled();

        public void sendPacket(MPKPacket var1);
    }

    public static enum PlayState {
        ACTIVE,
        AFK;

    }

    public static enum WorldState {
        MENU,
        SINGLE_PLAYER,
        MULTI_PLAYER;

    }
}

