/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.MCClasses;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class WorldInteraction {
    public static List<BoundingBox3D> getCollisionBoundingBoxes(Vector3D blockPosVec) {
        return Interface.get().map(w -> w.getCollisionBoundingBoxes(blockPosVec)).orElseGet(ArrayList::new);
    }

    public static Vector3D getLookingAt() {
        return Interface.get().map(Interface::getLookingAt).orElse(null);
    }

    public static String getLookingAtBlock() {
        return Optional.ofNullable(WorldInteraction.getLookingAt()).map(WorldInteraction::getBlockName).orElse(null);
    }

    public static String getBlockName(Vector3D blockPos) {
        return Interface.get().map(w -> w.getBlockName(blockPos)).orElse(null);
    }

    public static HashMap<String, String> getBlockProperties(Vector3D blockPos) {
        return Interface.get().map(w -> w.getBlockProperties(blockPos)).orElse(null);
    }

    public static List<BoundingBox3D> getLookingAtCollisionBoundingBoxes() {
        Vector3D blockPosVec = WorldInteraction.getLookingAt();
        if (blockPosVec == null) {
            return new ArrayList<BoundingBox3D>();
        }
        return WorldInteraction.getCollisionBoundingBoxes(blockPosVec);
    }

    public static interface Interface
    extends FunctionHolder {
        public static Optional<Interface> get() {
            return API.getFunctionHolder(Interface.class);
        }

        public List<BoundingBox3D> getCollisionBoundingBoxes(Vector3D var1);

        public Vector3D getLookingAt();

        public String getBlockName(Vector3D var1);

        public HashMap<String, String> getBlockProperties(Vector3D var1);
    }
}

