/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.SoundManager;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class Button
extends Component
implements MouseInputListener {
    public Color pressedColor = Theme.lightBackground;
    public Color normalColor = Theme.darkBackground;
    public Color hoverColor = Theme.hoverBackground;
    public Color textColor = Theme.defaultText;
    public Color disabledColor = Theme.disabledBackground;
    public Color disabledTextColor = Theme.disabledText;
    public Color pressedTextColor = Theme.darkText;
    public Vector2D textOffset = Vector2D.ZERO.copy();
    public boolean enabled = true;
    private ButtonCallback buttonCallback;
    private String text;
    private boolean isBeingPressed = false;

    public Button(String text) {
        this(text, null);
    }

    public Button(String text, ButtonCallback buttonCallback) {
        this.setSize(FontRenderer.getStringSize(text).add(2.0, 2.0));
        this.text = text;
        this.buttonCallback = buttonCallback;
    }

    public Button(String text, Vector2D pos, Vector2D size) {
        this(text, pos, size, null);
    }

    public Button(String text, Vector2D pos, Vector2D size, ButtonCallback buttonCallback) {
        this.setPos(pos);
        this.setSize(size);
        this.text = text;
        this.buttonCallback = buttonCallback;
    }

    public Button setButtonCallback(ButtonCallback buttonCallback) {
        this.buttonCallback = buttonCallback;
        return this;
    }

    public boolean isPressed() {
        return this.isBeingPressed;
    }

    public void setPressed(boolean pressed) {
        this.isBeingPressed = pressed;
    }

    @Override
    public void render(Vector2D mouse) {
        Color bg = !this.enabled ? this.disabledColor : (this.isBeingPressed ? this.pressedColor : (this.contains(mouse) ? this.hoverColor : this.normalColor));
        Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), bg);
        String text = this.getText();
        FontRenderer.drawCenteredString(text, this.getDisplayedPos().add(this.getDisplayedSize().div(2.0)).add(new Vector2D(0.5, text.toLowerCase().equals(text) ? 0.0 : 1.0)).add(this.textOffset), !this.enabled ? this.disabledTextColor : (this.isBeingPressed ? this.pressedTextColor : this.textColor), false);
    }

    public String getText() {
        return this.text;
    }

    public Button setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (!this.enabled) {
            return false;
        }
        if (this.contains(mousePos)) {
            switch (state) {
                case DOWN: {
                    this.isBeingPressed = true;
                    SoundManager.playButtonSound();
                    return true;
                }
                case UP: {
                    if (!this.isBeingPressed) break;
                    this.isBeingPressed = false;
                    if (this.buttonCallback != null) {
                        this.buttonCallback.apply(button);
                    }
                    return true;
                }
            }
        } else {
            switch (state) {
                case UP: 
                case DRAG: {
                    this.isBeingPressed = false;
                }
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface ButtonCallback {
        public void apply(Mouse.Button var1);
    }
}

