/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.KeyBinding;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.ColorSelector;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.StringUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class KeyBindingLabel
extends ResizableComponent {
    @JsonProperty
    public Color keyDownColor = new Color(255, 255, 255, 95);
    @JsonProperty
    public Color keyUpColor = new Color(31, 31, 31, 47);
    @JsonProperty
    public Color selectedColor = new Color(255, 170, 0, 100);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="displayName")
    private String displayName;
    private KeyBinding keyBinding;

    public KeyBindingLabel(Vector2D pos, Vector2D size, String name) {
        this.setPos(pos);
        this.setSize(size);
        this.name = name;
        this.updateKeyBinding();
    }

    private void updateKeyBinding() {
        this.keyBinding = KeyBinding.getByName(this.name);
        this.displayName = this.keyBinding == null ? this.name : StringUtil.capitalize(this.keyBinding.getDisplayName());
    }

    @JsonCreator
    public KeyBindingLabel(@JsonProperty(value="name") String name, @JsonProperty(value="displayName") String displayName) {
        this.setPos(this.pos);
        this.setSize(this.size);
        this.name = name;
        this.keyBinding = KeyBinding.getByName(name);
        this.updateKeyBinding();
        if (displayName != null) {
            this.displayName = displayName;
        }
    }

    @Override
    public void render(Vector2D mouse) {
        Color c;
        boolean keyDown;
        String displayName = this.displayName;
        boolean bl = keyDown = this.keyBinding != null && this.keyBinding.isKeyDown();
        Color color = this.selected ? this.selectedColor : (c = keyDown ? this.keyDownColor : this.keyUpColor);
        if (this.highlighted) {
            Renderer2D.drawDottedRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, 1.0, 1.0, Color.BLACK);
        }
        Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), c);
        FontRenderer.drawCenteredString(displayName, this.getDisplayedPos().add(this.getDisplayedSize().div(2.0)).add(new Vector2D(0.0, 1.0)), keyDown ? Color.BLACK : Color.WHITE, false);
        this.renderHoverEdges(mouse);
    }

    @Override
    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        EditPane editPane = new EditPane(Vector2D.ZERO, new Vector2D(0.4, 0.5));
        menu.addComponent(new Button("Edit", mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).passPositionTo(editPane, 12, Anchor.CENTER);
                ((MainGuiScreen)menu.paneHolder).openPane(editPane);
                menu.close();
            }
        }));
        menu.addComponent(new Button("Delete", mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).removeComponent(this);
                menu.close();
            }
        }));
        return menu;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    private class EditPane
    extends Pane<MainGuiScreen> {
        private final TextRectangle downKey;
        private final TextRectangle upKey;

        public EditPane(Vector2D pos, Vector2D size) {
            super(pos, size);
            this.upKey = new TextRectangle(new Vector2D(-0.16666666666666666, 5.0), KeyBindingLabel.this.getDisplayedSize(), KeyBindingLabel.this.displayName, KeyBindingLabel.this.keyUpColor, Color.WHITE);
            this.addChild(this.upKey, 1, Anchor.TOP_CENTER);
            this.downKey = new TextRectangle(new Vector2D(0.16666666666666666, 5.0), KeyBindingLabel.this.getDisplayedSize(), KeyBindingLabel.this.displayName, KeyBindingLabel.this.keyDownColor, Color.BLACK);
            this.addChild(this.downKey, 1, Anchor.TOP_CENTER);
            this.addChild(new ColorSelector(KeyBindingLabel.this.keyUpColor, new Vector2D(0.2, 0.4), color -> {
                KeyBindingLabel.this.keyUpColor = color;
            }), 3, Anchor.TOP_LEFT);
            this.addChild(new ColorSelector(KeyBindingLabel.this.keyDownColor, new Vector2D(0.2, 0.4), color -> {
                KeyBindingLabel.this.keyDownColor = color;
            }), 3, Anchor.TOP_RIGHT);
            this.addChild(new InputField(KeyBindingLabel.this.name, new Vector2D(0.0, 18.0), 0.95).setOnContentChange(content -> {
                KeyBindingLabel.this.name = content.getContent();
                KeyBindingLabel.this.keyBinding = KeyBinding.getByName(KeyBindingLabel.this.name);
            }), 5, Anchor.BOTTOM_CENTER);
            this.addChild(new InputField(KeyBindingLabel.this.displayName, new Vector2D(0.0, 5.0), 0.95).setOnContentChange(content -> {
                KeyBindingLabel.this.displayName = content.getContent();
                this.downKey.setText(KeyBindingLabel.this.displayName);
                this.upKey.setText(KeyBindingLabel.this.displayName);
            }), 5, Anchor.BOTTOM_CENTER);
            KeySetList list = new KeySetList(new Vector2D(0.025, 10.0), new Vector2D(0.25, -20.0));
            list.setAbsolute(true);
            this.addChild(list, 5, Anchor.TOP_LEFT);
            TreeSet<String> keyMap = new TreeSet<String>(KeyBinding.getKeyMap().keySet());
            HashMap modMap = new HashMap();
            Iterator<Object> iterator = keyMap.iterator();
            while (iterator.hasNext()) {
                String s;
                String modName = s.substring(0, !(s = (String)iterator.next()).contains(".") ? s.length() : s.indexOf("."));
                if (modName.equals("key")) {
                    modName = "Minecraft";
                }
                if (!modMap.containsKey(modName)) {
                    modMap.put(modName, new ArrayList());
                }
                ((ArrayList)modMap.get(modName)).add(s);
            }
            list.addItem(new KeySetListItem(list, "Minecraft (key.)", (ArrayList)modMap.get("Minecraft")));
            modMap.remove("Minecraft");
            for (String modName : new TreeSet(modMap.keySet())) {
                String exampleKey;
                String keyPrefix = "No Prefix found";
                String string = exampleKey = ((ArrayList)modMap.get(modName)).isEmpty() ? null : (String)((ArrayList)modMap.get(modName)).get(0);
                if (exampleKey != null) {
                    if (exampleKey.contains(".key.")) {
                        keyPrefix = exampleKey.substring(0, exampleKey.indexOf(".key.") + 5);
                    } else if (exampleKey.contains(".")) {
                        keyPrefix = exampleKey.substring(0, exampleKey.indexOf(".") + 1);
                    }
                }
                list.addItem(new KeySetListItem(list, modName + " (" + keyPrefix + ")", (ArrayList)modMap.get(modName)));
            }
        }

        @Override
        public void render(Vector2D mousePos) {
            this.upKey.setColor(KeyBindingLabel.this.keyUpColor);
            this.downKey.setColor(KeyBindingLabel.this.keyDownColor);
            super.render(mousePos);
        }

        private class KeySetListItem
        extends ScrollableListItem<KeySetListItem> {
            private static final int keyItemHeight = 12;
            private final String modName;
            private final ArrayList<String> keyNames;
            private final Button collapseButton;
            private boolean collapsed;

            public KeySetListItem(ScrollableList<KeySetListItem> parent, String modName, ArrayList<String> keyNames) {
                super(parent);
                this.collapsed = true;
                this.modName = modName;
                this.keyNames = keyNames;
                this.setHeight(13.0);
                this.collapseButton = new Button("v", new Vector2D(1.0, 1.0), new Vector2D(11.0, 11.0));
                this.collapseButton.setButtonCallback(mouseButton -> {
                    if (mouseButton != Mouse.Button.LEFT) {
                        return;
                    }
                    this.collapsed = !this.collapsed;
                    this.collapseButton.setText(this.collapsed ? "v" : "^");
                    this.collapseButton.textOffset = this.collapsed ? Vector2D.ZERO : new Vector2D(0.0, 3.0);
                });
                this.addChild(this.collapseButton, 0, Anchor.TOP_RIGHT);
            }

            @Override
            public int getHeight() {
                return this.collapsed ? 13 : 12 * (this.keyNames.size() + 1) + 1;
            }

            @Override
            public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
                if (this.collapsed) {
                    Renderer2D.drawRectWithEdge(pos, size, 1.0, new Color(31, 31, 31, 150), new Color(31, 31, 31, 150));
                    FontRenderer.drawCenteredString(this.modName, pos.add(size.div(2.0)), Color.WHITE, false);
                } else {
                    Renderer2D.drawRectWithEdge(pos, new Vector2D(size.getX(), 12.0), 1.0, new Color(31, 31, 31, 150), new Color(31, 31, 31, 150));
                    Renderer2D.drawRect(pos.add(0.0, 12.0), size.sub(0.0, 12.0), new Color(31, 31, 31, 150));
                    FontRenderer.drawCenteredString(this.modName, pos.add(size.getX() / 2.0, 6.0), Color.WHITE, false);
                    for (int i = 0; i < this.keyNames.size(); ++i) {
                        FontRenderer.drawCenteredString(this.keyNames.get(i), pos.add(size.getX() / 2.0, 18.0 + (double)(12 * i)), Color.WHITE, false);
                    }
                }
                this.renderComponents(mouse);
            }
        }

        private class KeySetList
        extends ScrollableList<KeySetListItem> {
            public KeySetList(Vector2D pos, Vector2D size) {
                this.setPos(pos);
                this.setSize(size);
                this.setTitle("Keybinding Names");
            }
        }
    }
}

