/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Plot
extends ResizableComponent {
    private static final double AXIS_MARGIN = 12.0;
    public Color edgeColor = new Color(100, 100, 100, 50);
    public Color selectedColor = new Color(255, 170, 0, 100);
    public Color backgroundColor = new Color(100, 100, 100, 40);
    protected int startX = -2;
    protected int endX = 3;
    protected int dataSize = this.endX - this.startX + 1;
    protected double minY = 0.0;
    protected double maxY = 90.0;
    protected double stepY = 10.0;
    protected List<Vector2D> dataPoints = null;
    protected List<Vector2D> renderPoints = null;
    protected Supplier<List<List<Double>>> dataSupplier = null;

    public Plot() {
        this.setMinSize(new Vector2D(40.0, 40.0));
    }

    public Plot setDataSupplier(Supplier<List<List<Double>>> dataSupplier) {
        this.dataSupplier = dataSupplier;
        return this;
    }

    @Override
    public void updatePosAndSize() {
        super.updatePosAndSize();
        this.updateRenderPoints();
    }

    public void updateRenderPoints() {
        if (this.dataPoints == null) {
            return;
        }
        Vector2D min = this.getDisplayedPos().add(12.0, 2.0);
        Vector2D max = this.getDisplayedPos().add(this.getDisplayedSize()).sub(2.0, 12.0);
        this.renderPoints = this.dataPoints.stream().map(p -> new Vector2D(MathUtil.map(p.getX(), (double)this.startX, (double)this.endX, min.getX(), max.getX()), MathUtil.map(p.getY(), this.minY, this.maxY, max.getY(), min.getY()))).collect(Collectors.toList());
    }

    @Override
    public void render(Vector2D mouse) {
        List<List<Double>> data;
        Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.selected ? this.selectedColor : this.backgroundColor, this.edgeColor);
        if (this.dataSupplier != null && (data = this.dataSupplier.get()) != null) {
            this.setData(data);
        }
        if (this.renderPoints != null && this.renderPoints.size() > 1) {
            Renderer2D.drawLines(this.renderPoints, Color.RED);
        }
        this.drawXAxis();
        this.drawYAxis();
    }

    public void setData(List<List<Double>> dataPoints) {
        this.dataPoints = new ArrayList<Vector2D>();
        for (int i = 0; i < dataPoints.size(); ++i) {
            double offset = 1.0 / (double)dataPoints.get(i).size();
            for (int d = 0; d < dataPoints.get(i).size(); ++d) {
                this.dataPoints.add(new Vector2D((double)(i + this.startX) + offset * (double)d, dataPoints.get(i).get(d)));
            }
        }
        this.updateRenderPoints();
    }

    private void drawXAxis() {
        double yPos = this.getDisplayedPos().getY() + this.getDisplayedSize().getY() - 12.0;
        Renderer2D.drawLine(new Vector2D(this.getDisplayedPos().getX() + 12.0, yPos), new Vector2D(this.getDisplayedPos().getX() + this.getDisplayedSize().getX() - 2.0, yPos), Color.WHITE);
        if (this.endX > this.startX) {
            for (int i = this.startX; i <= this.endX; ++i) {
                double xPos = MathUtil.map((double)i, (double)this.startX, (double)this.endX, this.getDisplayedPos().getX() + 12.0, this.getDisplayedPos().getX() + this.getDisplayedSize().getX() - 2.0);
                Renderer2D.drawLine(new Vector2D(xPos, yPos - 2.0), new Vector2D(xPos, yPos + 2.0), Color.WHITE);
                FontRenderer.drawCenteredString(String.valueOf(i), new Vector2D(xPos, yPos + 6.0 + 1.0), Color.WHITE, false);
            }
        }
    }

    private void drawYAxis() {
        double xPos = this.getDisplayedPos().getX() + 12.0;
        Renderer2D.drawLine(new Vector2D(xPos, this.getDisplayedPos().getY() + 2.0), new Vector2D(xPos, this.getDisplayedPos().getY() + this.getDisplayedSize().getY() - 12.0), Color.WHITE);
        if (this.maxY > this.minY) {
            for (double i = this.minY; i <= this.maxY; i += this.stepY) {
                double yPos = MathUtil.map(i, this.minY, this.maxY, this.getDisplayedPos().getY() + this.getDisplayedSize().getY() - 12.0, this.getDisplayedPos().getY() + 2.0);
                Renderer2D.drawLine(new Vector2D(xPos - 2.0, yPos), new Vector2D(xPos + 2.0, yPos), Color.WHITE);
                FontRenderer.drawCenteredString(String.valueOf(i), new Vector2D(xPos - 6.0 - 1.0, yPos), Color.WHITE, false);
            }
        }
    }
}

