/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.main_gui;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Div;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.LabelConfiguration;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SaveConfigPane
extends Pane<MainGuiScreen> {
    public static Color edgeColor = new Color(255, 255, 255, 95);
    private InputField filename;
    private ConfigFileList savedConfigs;

    public SaveConfigPane(Vector2D pos, Vector2D size) {
        super(pos, size);
        this.backgroundColor = new Color(16, 16, 16, 70);
        this.initComponents();
    }

    private void initComponents() {
        this.savedConfigs = new ConfigFileList(LabelConfiguration.savedConfigs, new Vector2D(0.06666666666666667, 0.05), new Vector2D(0.4, 0.9));
        this.savedConfigs.setTitle("Saved Configurations");
        this.addChild(this.savedConfigs, 15, Anchor.TOP_RIGHT);
        TextRectangle r = new TextRectangle(new Vector2D(0.0, 40.0), new Vector2D(1.0, 15.0), "Filename", new Color(0, 0, 0, 0), Color.WHITE);
        this.filename = new InputField("", new Vector2D(0.0, 25.0), 0.9).setFilter(InputField.FILTER_FILENAME).setOnContentChange(content -> this.savedConfigs.updateItems());
        Button b = new Button("Save", new Vector2D(0.0, 0.0), new Vector2D(0.9, 20.0), mouseButton -> {
            if (mouseButton != Mouse.Button.LEFT) {
                return;
            }
            if (this.filename.content.isEmpty()) {
                return;
            }
            LabelConfiguration.currentConfig.save(this.filename.content);
            this.filename.clear();
            this.savedConfigs.reloadItems();
            this.savedConfigs.updateItems();
            ((MainGuiScreen)this.paneHolder).loadConfigPane.reload();
        });
        Div fileDiv = new Div(new Vector2D(0.06666666666666667, 0.0), new Vector2D(0.4, 50.0));
        fileDiv.addChild(r, 4, Anchor.BOTTOM_CENTER);
        fileDiv.addChild(this.filename, 4, Anchor.BOTTOM_CENTER);
        fileDiv.addChild(b, 4, Anchor.BOTTOM_CENTER);
        this.addChild(fileDiv, 5, Anchor.CENTER_LEFT);
    }

    private class ConfigFileListItem
    extends ScrollableListItem<ConfigFileListItem> {
        private final Button delete;
        public String file;

        public ConfigFileListItem(ConfigFileList parent, String file) {
            super(parent);
            this.setHeight(25.0);
            this.file = file;
            this.delete = new Button("Delete", new Vector2D(5.0, 0.0), new Vector2D(30.0, 20.0), mouseButton -> {
                if (mouseButton != Mouse.Button.LEFT) {
                    return;
                }
                LabelConfiguration.delete(file);
                parent.reloadItems();
                parent.updateItems();
                ((MainGuiScreen)SaveConfigPane.this.paneHolder).loadConfigPane.reload();
            });
            this.delete.textColor = Color.RED;
            this.addChild(this.delete, 0, Anchor.CENTER_RIGHT);
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            Renderer2D.drawHollowRect(pos.add(1.0), size.sub(2.0), 1.0, edgeColor);
            FontRenderer.drawLeftCenteredString(this.file, pos.add(5.0, size.getY() / 2.0), Color.WHITE, true);
            this.delete.render(mouse);
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            return this.delete.handleMouseInput(state, mousePos, button);
        }
    }

    private class ConfigFileList
    extends ScrollableList<ConfigFileListItem> {
        public Map<String, LabelConfiguration> configurationMap;
        public List<ConfigFileListItem> allItems;

        public ConfigFileList(Map<String, LabelConfiguration> configurationMap, Vector2D pos, Vector2D size) {
            this.setPos(pos);
            this.setSize(size);
            this.configurationMap = configurationMap;
            this.reloadItems();
            this.items.clear();
            this.items.addAll(this.allItems);
        }

        public void reloadItems() {
            this.allItems = this.configurationMap.keySet().stream().map(configuration -> new ConfigFileListItem(this, (String)configuration)).sorted(Comparator.comparing(i -> i.file)).collect(Collectors.toList());
        }

        @Override
        public void render(Vector2D mouse) {
            super.render(mouse);
        }

        public void updateItems() {
            this.items.clear();
            for (ConfigFileListItem item : this.allItems) {
                if (!item.file.toLowerCase().contains(((SaveConfigPane)SaveConfigPane.this).filename.content.toLowerCase())) continue;
                this.items.add(item);
            }
        }
    }
}

