/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.options_gui;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.save.Serializer;
import io.github.kurrycat.mpkmod.util.ClassUtil;
import io.github.kurrycat.mpkmod.util.JSONConfig;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Option {
    private String name;
    private String value;
    private String defaultValue;
    private ValueType type;
    private String category = "";
    private OptionChangeListener changeListener;
    private java.lang.reflect.Field linkedField = null;
    private String displayName = null;
    private String description = null;
    private boolean showInOptionList;

    public Option(String name, String value, String defaultValue) {
        this(name, value, defaultValue, ValueType.STRING);
    }

    public Option(String name, String value, String defaultValue, ValueType type) {
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public Option(String name, Boolean value, Boolean defaultValue) {
        this(name, value.toString(), defaultValue.toString(), ValueType.BOOLEAN);
    }

    public static HashMap<String, Option> createOptionMap() {
        HashMap<String, Option> optionMap = new HashMap<String, Option>();
        List<Tuple<Field, java.lang.reflect.Field>> annotations = ClassUtil.getFieldAnnotations(Field.class);
        for (Tuple<Field, java.lang.reflect.Field> t : annotations) {
            String value;
            Field a = t.getFirst();
            java.lang.reflect.Field f = t.getSecond();
            String id = f.getName();
            try {
                value = f.get(null).toString();
            }
            catch (IllegalAccessException e) {
                API.LOGGER.debug(API.CONFIG_MARKER, "OptionMap: IllegalAccessException while trying to access field {} from {}", new Object[]{id, f.getDeclaringClass().getName()});
                continue;
            }
            catch (NullPointerException e) {
                API.LOGGER.debug(API.CONFIG_MARKER, "OptionMap: Option field for Option with id: {} in the class {} is not static", new Object[]{id, f.getDeclaringClass().getName()});
                continue;
            }
            ValueType type = ValueType.STRING;
            if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                type = ValueType.BOOLEAN;
            }
            if (f.getType() == Double.class || f.getType() == Double.TYPE) {
                type = ValueType.DOUBLE;
            }
            if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                type = ValueType.INTEGER;
            }
            if (f.getType() == Color.class) {
                type = ValueType.COLOR;
            }
            Option option = new Option(id, value, value, type).setCategory(a.category()).setDisplayName(a.displayName()).setDescription(a.description()).setShowInOptionList(a.showInOptionList()).link(f);
            optionMap.put(id, option);
            API.LOGGER.debug("Option of type {} added to map: {} with default value: {}", new Object[]{type, id, value});
        }
        List<Tuple<ChangeListener, Method>> listeners = ClassUtil.getMethodAnnotations(ChangeListener.class);
        for (Tuple<ChangeListener, Method> l : listeners) {
            ChangeListener c = l.getFirst();
            Method m = l.getSecond();
            String fieldName = c.field();
            if (!optionMap.containsKey(fieldName)) continue;
            optionMap.get(fieldName).setChangeListener(() -> {
                try {
                    m.invoke(m.getDeclaringClass(), new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException ignored) {
                    API.LOGGER.debug("Failed to invoke changeListener for option: {} ", new Object[]{fieldName});
                }
            });
            API.LOGGER.debug("Option listener added for: {} ", new Object[]{fieldName});
        }
        API.LOGGER.info("{} Options registered", new Object[]{optionMap.size()});
        return optionMap;
    }

    public Option link(java.lang.reflect.Field field) {
        this.linkedField = field;
        return this;
    }

    public Option setShowInOptionList(boolean showInOptionList) {
        this.showInOptionList = showInOptionList;
        return this;
    }

    public static void updateOptionMapFromFields() {
        for (Option o : API.optionsMap.values()) {
            o.updateFromField();
        }
    }

    private void updateFromField() {
        if (this.linkedField == null) {
            return;
        }
        try {
            this.value = this.linkedField.get(null).toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void updateOptionMapFromJSON(boolean suppressChangeListener) {
        HashMap<String, String> deserializedInfo = Serializer.deserializeAny(JSONConfig.optionsFile, new TypeReference<HashMap<String, String>>(){});
        if (deserializedInfo == null) {
            return;
        }
        for (String key : deserializedInfo.keySet()) {
            if (!API.optionsMap.containsKey(key)) continue;
            API.optionsMap.get(key).setValue(deserializedInfo.get(key), suppressChangeListener);
        }
    }

    public Option setValue(String value, boolean suppressChangeListener) {
        if (this.value.equals(value)) {
            return this;
        }
        this.value = value;
        if (this.linkedField != null) {
            try {
                this.linkedField.set(this.linkedField.getDeclaringClass(), this.getAsType());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (!suppressChangeListener && this.changeListener != null) {
            this.changeListener.onOptionChange();
        }
        return this;
    }

    public Object getAsType() {
        switch (this.type) {
            case BOOLEAN: {
                return this.getBoolean();
            }
            case INTEGER: {
                return this.getInteger();
            }
            case DOUBLE: {
                return this.getDouble();
            }
        }
        return this.getValue();
    }

    public Boolean getBoolean() {
        if (this.type == ValueType.BOOLEAN) {
            return this.value.equals("true");
        }
        return null;
    }

    public Option setBoolean(Boolean value) {
        if (ValueType.BOOLEAN.equals((Object)this.type)) {
            this.setValue(value.toString());
        }
        return this;
    }

    public Integer getInteger() {
        if (this.type == ValueType.INTEGER) {
            return Integer.parseInt(this.value);
        }
        return 0;
    }

    public Double getDouble() {
        if (this.type == ValueType.DOUBLE) {
            return Double.parseDouble(this.value);
        }
        return 0.0;
    }

    @JsonGetter(value="value")
    public String getValue() {
        return this.value;
    }

    public Option setValue(String value) {
        return this.setValue(value, false);
    }

    public static void saveOptionMapToJSON() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String key : API.optionsMap.keySet()) {
            options.put(key, API.optionsMap.get(key).getValue());
        }
        Serializer.serialize(JSONConfig.optionsFile, options);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Option setDisplayName(String s) {
        this.displayName = s;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Option setDescription(String s) {
        this.description = s;
        return this;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    public Option setName(String name) {
        this.name = name;
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public Option setCategory(String category) {
        this.category = category;
        return this;
    }

    public boolean shouldShowInOptionList() {
        return this.showInOptionList;
    }

    public OptionChangeListener getChangeListener() {
        return this.changeListener;
    }

    public Option setChangeListener(OptionChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @JsonGetter(value="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Option setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @JsonGetter(value="valueType")
    public ValueType getType() {
        return this.type;
    }

    public Option setType(ValueType type) {
        this.type = type;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return this.name.equals(option.name);
    }

    @FunctionalInterface
    public static interface OptionChangeListener {
        public void onOptionChange();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ChangeListener {
        public String field();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Field {
        public String category() default "";

        public String displayName() default "";

        public String description() default "";

        public boolean showInOptionList() default true;
    }

    public static enum ValueType {
        STRING,
        DOUBLE,
        INTEGER,
        BOOLEAN,
        COLOR;

    }
}

