/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.save.Serializer;
import io.github.kurrycat.mpkmod.ticks.Timing;
import io.github.kurrycat.mpkmod.ticks.TimingInput;
import io.github.kurrycat.mpkmod.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimingStorage {
    private static final String defaultStratFileName = "/assets/mpkmod/strats/strats.json";
    private static final String stratFileName = "config/mpk/config/strats.json";
    public static Map<String, Timing> patterns = new HashMap<String, Timing>();
    @Option.Field(category="labels", displayName="Display ms for lastTiming", description="Enable whether milliseconds should be shown in the lastTiming infoVar")
    public static boolean renderLastTimingMS = false;

    public static void init() {
        InputStream stratFile = FileUtil.getResource(defaultStratFileName);
        patterns = Serializer.deserializeAny(stratFile, new TypeReference<HashMap<String, Timing>>(){});
        File file = new File(stratFileName);
        if (!file.exists()) {
            FileUtil.createFile(stratFileName, "{}");
        }
        patterns.putAll((Map<String, Timing>)Serializer.deserializeAny(file, new TypeReference<HashMap<String, Timing>>(){}));
        if (patterns == null) {
            return;
        }
        API.LOGGER.info(API.CONFIG_MARKER, "{} Timings loaded from {}", new Object[]{patterns.size(), stratFileName});
    }

    public static String match(List<TimingInput> inputList) {
        ArrayList<Timing.Match> matches = new ArrayList<Timing.Match>();
        for (Map.Entry<String, Timing> entry : patterns.entrySet()) {
            Timing.Match match = entry.getValue().match(inputList);
            if (match == null) continue;
            matches.add(match);
        }
        if (matches.isEmpty()) {
            return null;
        }
        matches.sort(null);
        return ((Timing.Match)matches.get((int)0)).displayString;
    }
}

