/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import io.github.kurrycat.mpkmod.util.Line2D;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.util.HashMap;

public class BoundingBox2D {
    private Vector2D min;
    private Vector2D max;

    public BoundingBox2D(Vector2D corner1, Vector2D corner2) {
        this.min = new Vector2D(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()));
        this.max = new Vector2D(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()));
    }

    public static BoundingBox2D fromPosSize(Vector2D pos, Vector2D size) {
        return new BoundingBox2D(pos.copy(), pos.add(size));
    }

    public Vector2D getMin() {
        return this.min.copy();
    }

    public Vector2D getMax() {
        return this.max.copy();
    }

    public Vector2D topLeft() {
        return this.min.copy();
    }

    public Vector2D bottomRight() {
        return this.max.copy();
    }

    public Vector2D topRight() {
        return new Vector2D(this.max.getX(), this.min.getY());
    }

    public Vector2D bottomLeft() {
        return new Vector2D(this.min.getX(), this.max.getY());
    }

    public Vector2D getSize() {
        return this.max.sub(this.min);
    }

    public double minX() {
        return this.min.getX();
    }

    public double maxX() {
        return this.max.getX();
    }

    public double minY() {
        return this.min.getY();
    }

    public double maxY() {
        return this.max.getY();
    }

    public boolean contains(Vector2D pos) {
        return pos.isInRectBetween(this.min, this.max);
    }

    public boolean onEdge(Vector2D pos, Edge edge, double maxError) {
        Line2D l = edge.getLine(this);
        return l.distanceToPos(pos) < maxError;
    }

    public Edge[] allOnEdge(Vector2D pos, double maxError) {
        HashMap<Edge, Double> edges = new HashMap<Edge, Double>();
        for (Edge e : Edge.values()) {
            double dist = e.getLine(this).distanceToPos(pos);
            if (!(dist < maxError) || edges.containsKey((Object)e.getOpposite()) && !(dist < (Double)edges.get((Object)e.getOpposite()))) continue;
            edges.put(e, dist);
            edges.remove((Object)e.getOpposite());
        }
        return edges.keySet().toArray(new Edge[0]);
    }

    public static enum Edge {
        LEFT(Vector2D.LEFT),
        RIGHT(Vector2D.RIGHT),
        TOP(Vector2D.UP),
        BOTTOM(Vector2D.DOWN);

        public final Vector2D dir;

        private Edge(Vector2D dir) {
            this.dir = dir;
        }

        public static Edge byDir(Vector2D dir) {
            for (Edge e : Edge.values()) {
                if (!e.dir.equals(dir)) continue;
                return e;
            }
            return null;
        }

        public Line2D getLine(BoundingBox2D bb) {
            switch (this) {
                default: {
                    return new Line2D(bb.topLeft(), bb.topRight());
                }
                case BOTTOM: {
                    return new Line2D(bb.bottomLeft(), bb.bottomRight());
                }
                case LEFT: {
                    return new Line2D(bb.topLeft(), bb.bottomLeft());
                }
                case RIGHT: 
            }
            return new Line2D(bb.topRight(), bb.bottomRight());
        }

        public Edge getOpposite() {
            return Edge.byDir(this.dir.mult(-1.0));
        }
    }
}

