/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.util.FileUtil;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ClassUtil {
    public static Class<?> ModClass = null;
    private static Set<Class<?>> classes = null;
    private static File modJarFile = null;

    public static File getJarFile() {
        if (modJarFile != null) {
            return modJarFile;
        }
        try {
            modJarFile = new File(ClassUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            API.LOGGER.info("Failed to get mod jar path");
        }
        return modJarFile;
    }

    public static <A extends Annotation> List<Tuple<A, Class<?>>> getClassAnnotations(Class<A> annotationClass) {
        return ClassUtil.getClassAnnotations(ClassUtil.classes(), annotationClass);
    }

    public static <A extends Annotation> List<Tuple<A, Class<?>>> getClassAnnotations(Collection<Class<?>> classes, Class<A> annotationClass) {
        ArrayList annotations = new ArrayList();
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(annotationClass)) continue;
            annotations.add(new Tuple(c.getAnnotation(annotationClass), c));
        }
        return annotations;
    }

    private static Set<Class<?>> classes() {
        if (classes == null) {
            InputStream in = FileUtil.getResource("classes.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            classes = new HashSet();
            try {
                String[] classList;
                for (String s : classList = reader.readLine().split(";")) {
                    classes.add(Class.forName(s));
                }
            }
            catch (IOException | ClassNotFoundException ignored) {
                API.LOGGER.fatal("Failed to load all classes in classes.txt, maybe it was not regenerated correctly?");
            }
        }
        return classes;
    }

    public static <A extends Annotation> List<Tuple<A, Field>> getFieldAnnotations(Class<A> annotationClass) {
        return ClassUtil.getFieldAnnotations(ClassUtil.classes(), annotationClass);
    }

    public static <A extends Annotation> List<Tuple<A, Field>> getFieldAnnotations(Collection<Class<?>> classes, Class<A> annotationClass) {
        ArrayList<Tuple<A, Field>> annotations = new ArrayList<Tuple<A, Field>>();
        for (Class<?> c : classes) {
            for (Field f : c.getFields()) {
                if (!f.isAnnotationPresent(annotationClass)) continue;
                annotations.add(new Tuple<A, Field>(f.getAnnotation(annotationClass), f));
            }
        }
        return annotations;
    }

    public static <A extends Annotation> List<Tuple<A, Method>> getMethodAnnotations(Class<A> annotationClass) {
        return ClassUtil.getMethodAnnotations(ClassUtil.classes(), annotationClass);
    }

    public static <A extends Annotation> List<Tuple<A, Method>> getMethodAnnotations(Collection<Class<?>> classes, Class<A> annotationClass) {
        ArrayList<Tuple<A, Method>> annotations = new ArrayList<Tuple<A, Method>>();
        for (Class<?> c : classes) {
            for (Method m : c.getMethods()) {
                if (!m.isAnnotationPresent(annotationClass)) continue;
                annotations.add(new Tuple<A, Method>(m.getAnnotation(annotationClass), m));
            }
        }
        return annotations;
    }

    public static List<Class<?>> classes(String packageName) {
        String path = packageName.replace(".", File.separator);
        String path2 = packageName.replace(".", "/");
        ArrayList classes = new ArrayList();
        String classPaths = System.getProperty("java.class.path");
        if (classPaths == null || !classPaths.contains(path) && !classPaths.contains(path2)) {
            classPaths = System.getProperty("legacyClassPath");
        }
        if (classPaths == null) {
            return classes;
        }
        String[] classPathEntries = classPaths.split(System.getProperty("path.separator"));
        API.LOGGER.info(classPaths);
        for (String classpathEntry : classPathEntries) {
            String name;
            if (classpathEntry.endsWith(".jar")) {
                File jar = new File(classpathEntry);
                try {
                    JarEntry entry;
                    JarInputStream is = new JarInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));
                    while ((entry = is.getNextJarEntry()) != null) {
                        name = entry.getName();
                        if (!name.endsWith(".class") || !name.contains(path) && !name.contains(path2)) continue;
                        String classPath = name.substring(0, entry.getName().length() - 6);
                        classPath = classPath.replaceAll("[|/]", ".");
                        classes.add(Class.forName(classPath));
                    }
                    continue;
                }
                catch (Exception ex) {
                    API.LOGGER.debug("Exception during class loading: ", (Throwable)ex);
                    continue;
                }
            }
            try {
                File base = new File(classpathEntry + File.separatorChar + path);
                if (!base.isDirectory()) continue;
                for (File file : Objects.requireNonNull(base.listFiles())) {
                    name = file.getName();
                    if (!name.endsWith(".class")) continue;
                    name = name.substring(0, name.length() - 6);
                    classes.add(Class.forName(packageName + "." + name));
                }
            }
            catch (Exception ex) {
                API.LOGGER.debug("Exception during class loading: ", (Throwable)ex);
            }
        }
        return classes;
    }

    public static void setModClass(Class<?> callerClass) {
        ModClass = callerClass;
    }
}

