/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.forge_1_12_2;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.InputConstants;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Keyboard;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Profiler;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer3D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.SoundManager;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.WorldInteraction;
import io.github.kurrycat.mpkmod.compatibility.forge_1_12_2.MPKGuiScreen;
import io.github.kurrycat.mpkmod.compatibility.forge_1_12_2.MPKMod;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.Debug;
import io.github.kurrycat.mpkmod.util.ScissorBox;
import io.github.kurrycat.mpkmod.util.Vector2D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import io.github.kurrycat.mpknetapi.common.network.packet.MPKPacket;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class FunctionCompatibility
implements FunctionHolder,
SoundManager.Interface,
WorldInteraction.Interface,
Renderer3D.Interface,
Renderer2D.Interface,
FontRenderer.Interface,
Minecraft.Interface,
Keyboard.Interface,
Profiler.Interface {
    private static final Stack<ScissorBox> scissorStack = new Stack();

    @Override
    public void playButtonSound() {
        net.minecraft.client.Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public List<BoundingBox3D> getCollisionBoundingBoxes(Vector3D blockPosVec) {
        BlockPos blockPos = new BlockPos(blockPosVec.getX(), blockPosVec.getY(), blockPosVec.getZ());
        WorldClient world = net.minecraft.client.Minecraft.func_71410_x().field_71441_e;
        IBlockState blockState = world.func_180495_p(blockPos);
        AxisAlignedBB mask = new AxisAlignedBB(blockPosVec.getX() - 1.0, blockPosVec.getY() - 1.0, blockPosVec.getZ() - 1.0, blockPosVec.getX() + 1.0, blockPosVec.getY() + 1.0, blockPosVec.getZ() + 1.0);
        ArrayList result = new ArrayList();
        blockState.func_185908_a((World)world, blockPos, mask, result, null, false);
        return result.stream().map(aabb -> new BoundingBox3D(new Vector3D(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vector3D(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f))).collect(Collectors.toList());
    }

    @Override
    public Vector3D getLookingAt() {
        BlockPos blockPos = net.minecraft.client.Minecraft.func_71410_x().field_71439_g.func_174822_a(20.0, 0.0f).func_178782_a();
        if (blockPos == null) {
            return null;
        }
        return new Vector3D(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    @Override
    public String getBlockName(Vector3D blockPos) {
        String blockName = "";
        BlockPos blockpos = new BlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        IBlockState iblockstate = net.minecraft.client.Minecraft.func_71410_x().field_71441_e.func_180495_p(blockpos);
        if (net.minecraft.client.Minecraft.func_71410_x().field_71441_e.func_175624_G() != WorldType.field_180272_g) {
            iblockstate = iblockstate.func_177230_c().func_176221_a(iblockstate, (IBlockAccess)net.minecraft.client.Minecraft.func_71410_x().field_71441_e, blockpos);
        }
        blockName = String.valueOf(iblockstate.func_177230_c().func_149732_F());
        return blockName;
    }

    @Override
    public HashMap<String, String> getBlockProperties(Vector3D blockPos) {
        HashMap<String, String> properties = new HashMap<String, String>();
        BlockPos blockpos = new BlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        IBlockState iblockstate = net.minecraft.client.Minecraft.func_71410_x().field_71441_e.func_180495_p(blockpos);
        if (net.minecraft.client.Minecraft.func_71410_x().field_71441_e.func_175624_G() != WorldType.field_180272_g) {
            iblockstate = iblockstate.func_177230_c().func_176221_a(iblockstate, (IBlockAccess)net.minecraft.client.Minecraft.func_71410_x().field_71441_e, blockpos);
        }
        for (Map.Entry e : iblockstate.func_177228_b().entrySet()) {
            properties.put(((IProperty)e.getKey()).func_177701_a(), ((Comparable)e.getValue()).toString());
        }
        return properties;
    }

    @Override
    public void drawBox(BoundingBox3D bb, Color color, float partialTicks) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2848);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        Entity entity = net.minecraft.client.Minecraft.func_71410_x().func_175606_aa();
        double entityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double entityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double entityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        wr.func_178969_c(-entityX, -entityY, -entityZ);
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.minX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.minZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.maxY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(bb.maxX(), bb.minY(), bb.maxZ()).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)2848);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawRect(Vector2D pos, Vector2D size, Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        double x = pos.getX();
        double y = pos.getY();
        double w = size.getX();
        double h = size.getY();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b(x, y + h, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + w, y + h, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + w, y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public void drawLines(Collection<Vector2D> points, Color color) {
        if (points.size() < 2) {
            Debug.stacktrace("At least two points expected, got: " + points.size());
            return;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)2848);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (Vector2D p : points) {
            wr.func_181662_b(p.getX(), p.getY(), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        }
        wr.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)2848);
        GlStateManager.func_179121_F();
    }

    @Override
    public Vector2D getScaledSize() {
        ScaledResolution r = new ScaledResolution(net.minecraft.client.Minecraft.func_71410_x());
        return new Vector2D(r.func_78327_c(), r.func_78324_d());
    }

    @Override
    public Vector2D getScreenSize() {
        return new Vector2D(net.minecraft.client.Minecraft.func_71410_x().field_71443_c, net.minecraft.client.Minecraft.func_71410_x().field_71440_d);
    }

    @Override
    public void enableScissor(double x, double y, double w, double h) {
        ScissorBox box;
        if (scissorStack.isEmpty()) {
            box = new ScissorBox(x, y, w, h);
        } else {
            ScissorBox prev = scissorStack.peek();
            double bx = Math.max(prev.x, x);
            double by = Math.max(prev.y, y);
            box = new ScissorBox(bx, by, Math.min(x + w, prev.x + prev.w) - bx, Math.min(y + h, prev.y + prev.h) - by);
        }
        scissorStack.push(box);
        this.setScissor(box);
    }

    @Override
    public void disableScissor() {
        if (!scissorStack.isEmpty()) {
            scissorStack.pop();
        }
        if (scissorStack.isEmpty()) {
            this.setScissor(null);
        } else {
            this.setScissor(scissorStack.peek());
        }
    }

    @Override
    public void clearScissors() {
        scissorStack.clear();
        this.setScissor(null);
    }

    private void setScissor(ScissorBox box) {
        if (box == null) {
            GL11.glDisable((int)3089);
        } else {
            GL11.glEnable((int)3089);
            ScaledResolution r = new ScaledResolution(net.minecraft.client.Minecraft.func_71410_x());
            double scaleFactor = r.func_78325_e();
            double posX = box.x * scaleFactor;
            double posY = (double)net.minecraft.client.Minecraft.func_71410_x().field_71440_d - (box.y + box.h) * scaleFactor;
            double width = box.w * scaleFactor;
            double height = box.h * scaleFactor;
            GL11.glScissor((int)((int)posX), (int)((int)posY), (int)Math.max(0, (int)width), (int)Math.max(0, (int)height));
        }
    }

    @Override
    public boolean scissorContains(Vector2D point) {
        return scissorStack.isEmpty() || scissorStack.peek().contains(point);
    }

    @Override
    public void drawString(String text, double x, double y, Color color, double fontSize, boolean shadow) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        double scale = fontSize / (double)((float)net.minecraft.client.Minecraft.func_71410_x().field_71466_p.field_78288_b * 1.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        net.minecraft.client.Minecraft.func_71410_x().field_71466_p.func_175065_a(text, 0.0f, 0.0f, color.getRGB(), shadow);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    @Override
    public Vector2D getStringSize(String text, double fontSize) {
        double scale = fontSize / (double)((float)net.minecraft.client.Minecraft.func_71410_x().field_71466_p.field_78288_b * 1.0f);
        return new Vector2D((double)net.minecraft.client.Minecraft.func_71410_x().field_71466_p.func_78256_a(text) * scale, fontSize);
    }

    @Override
    public String getIP() {
        ServerData d = net.minecraft.client.Minecraft.func_71410_x().func_147104_D();
        if (d == null) {
            return "Multiplayer";
        }
        return d.field_78845_b;
    }

    @Override
    public String getFPS() {
        return String.valueOf(net.minecraft.client.Minecraft.func_175610_ah());
    }

    @Override
    public void displayGuiScreen(io.github.kurrycat.mpkmod.gui.MPKGuiScreen screen) {
        net.minecraft.client.Minecraft.func_71410_x().func_152344_a(() -> net.minecraft.client.Minecraft.func_71410_x().func_147108_a((GuiScreen)(screen == null ? null : new MPKGuiScreen(screen))));
    }

    @Override
    public String getCurrentGuiScreen() {
        GuiScreen curr = net.minecraft.client.Minecraft.func_71410_x().field_71462_r;
        if (curr == null) {
            return null;
        }
        if (curr instanceof MPKGuiScreen) {
            String id = ((MPKGuiScreen)curr).eventReceiver.getID();
            if (id == null) {
                id = "unknown";
            }
            return id;
        }
        return curr.getClass().getSimpleName();
    }

    @Override
    public String getUserName() {
        if (net.minecraft.client.Minecraft.func_71410_x().field_71439_g == null) {
            return null;
        }
        return net.minecraft.client.Minecraft.func_71410_x().field_71439_g.func_70005_c_();
    }

    @Override
    public void copyToClipboard(String content) {
        StringSelection selection = new StringSelection(content);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    @Override
    public boolean isF3Enabled() {
        return net.minecraft.client.Minecraft.func_71410_x().field_71474_y.field_74330_P;
    }

    @Override
    public void sendPacket(MPKPacket packet) {
        MPKMod.FORGE_NETWORKING.sendPacket(packet);
    }

    @Override
    public boolean setInputs(Float yaw, boolean relYaw, Float pitch, boolean relPitch, int pressedInputs, int releasedInputs, int L, int R) {
        int i;
        if (!Minecraft.isSingleplayer()) {
            return false;
        }
        EntityPlayerSP player = net.minecraft.client.Minecraft.func_71410_x().field_71439_g;
        GameSettings gs = net.minecraft.client.Minecraft.func_71410_x().field_71474_y;
        float prevPitch = player.field_70125_A;
        float prevYaw = player.field_70177_z;
        if (yaw != null) {
            player.field_70177_z = relYaw ? (float)((double)player.field_70177_z + (double)yaw.floatValue()) : yaw.floatValue();
            player.field_70126_B += player.field_70177_z - prevYaw;
        }
        if (pitch != null) {
            player.field_70125_A = relPitch ? (float)((double)player.field_70125_A - (double)pitch.floatValue()) : pitch.floatValue();
            player.field_70125_A = MathHelper.func_76131_a((float)player.field_70125_A, (float)-90.0f, (float)90.0f);
            player.field_70127_C += player.field_70125_A - prevPitch;
        }
        int[] keys = new int[]{gs.field_74351_w.func_151463_i(), gs.field_74370_x.func_151463_i(), gs.field_74368_y.func_151463_i(), gs.field_74366_z.func_151463_i(), gs.field_151444_V.func_151463_i(), gs.field_74311_E.func_151463_i(), gs.field_74314_A.func_151463_i()};
        for (i = 0; i < keys.length; ++i) {
            if ((releasedInputs & 1 << i) != 0) {
                KeyBinding.func_74510_a((int)keys[i], (boolean)false);
            }
            if ((pressedInputs & 1 << i) == 0) continue;
            KeyBinding.func_74510_a((int)keys[i], (boolean)true);
            KeyBinding.func_74507_a((int)keys[i]);
        }
        KeyBinding.func_74510_a((int)gs.field_74312_F.func_151463_i(), (L > 0 ? 1 : 0) != 0);
        for (i = 0; i < L; ++i) {
            KeyBinding.func_74507_a((int)gs.field_74312_F.func_151463_i());
        }
        KeyBinding.func_74510_a((int)gs.field_74313_G.func_151463_i(), (R > 0 ? 1 : 0) != 0);
        for (i = 0; i < R; ++i) {
            KeyBinding.func_74507_a((int)gs.field_74313_G.func_151463_i());
        }
        return true;
    }

    @Override
    public List<Integer> getPressedButtons() {
        ArrayList<Integer> keysDown = new ArrayList<Integer>();
        for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
            if (!Keyboard.isKeyDown((int)i)) continue;
            keysDown.add(InputConstants.convert(i));
        }
        return keysDown;
    }

    @Override
    public void startSection(String name) {
        net.minecraft.client.Minecraft.func_71410_x().field_71424_I.func_76320_a(name);
    }

    @Override
    public void endStartSection(String name) {
        net.minecraft.client.Minecraft.func_71410_x().field_71424_I.func_76318_c(name);
    }

    @Override
    public void endSection() {
        net.minecraft.client.Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }
}

