/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Keyboard;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.gui.components.TextCheckButton;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

public class AnglePath
extends ResizableComponent
implements MouseScrollListener {
    protected final Deque<DataPoint> dataPoints;
    public Color selectedColor = new Color(255, 170, 0, 100);
    @JsonProperty(value="mode")
    public Mode mode = Mode.X_Y;
    @JsonProperty(value="timeWindow")
    public int timeWindow = 10;
    protected Deque<Vector2D> renderPoints;
    protected long lastTick = -1L;
    private boolean fullScreen;
    private long displayTime = 0L;
    private long startTime = 0L;

    @JsonCreator
    public AnglePath(@JsonProperty(value="fullscreen") boolean fullScreen) {
        this.fullScreen = fullScreen;
        this.dataPoints = new LinkedList<DataPoint>();
        this.renderPoints = new LinkedList<Vector2D>();
    }

    @JsonGetter(value="fullscreen")
    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        if (fullScreen != this.fullScreen) {
            this.fullScreen = fullScreen;
            this.reloadRenderPoints();
        }
        this.fullScreen = fullScreen;
    }

    @Override
    public void updatePosAndSize() {
        super.updatePosAndSize();
        this.reloadRenderPoints();
    }

    protected void reloadRenderPoints() {
        this.renderPoints = new LinkedList<Vector2D>();
        Iterator<DataPoint> it = this.dataPoints.descendingIterator();
        while (it.hasNext()) {
            DataPoint dataPoint = it.next();
            for (Vector2D v : this.dataToRenderPoint(dataPoint)) {
                this.renderPoints.addFirst(v);
            }
        }
    }

    protected Collection<Vector2D> dataToRenderPoint(DataPoint dataPoint) {
        Vector2D screenSize = Renderer2D.getScreenSize();
        double ssX = screenSize.getX();
        double ssY = screenSize.getY();
        Vector2D pos = this.fullScreen ? Vector2D.ZERO : this.getDisplayedPos();
        double minX = pos.getX();
        double minY = pos.getY();
        Vector2D size = this.fullScreen ? Renderer2D.getScaledSize() : this.getDisplayedSize();
        double maxX = minX + size.getX();
        double maxY = minY + size.getY();
        LinkedList<Vector2D> list = new LinkedList<Vector2D>();
        int len = dataPoint.x.length;
        int time = (int)(dataPoint.tickTime - this.displayTime);
        for (int i = 0; i < len; ++i) {
            double y;
            double x;
            switch (this.mode) {
                case X_Y: {
                    x = MathUtil.map((double)dataPoint.x[i], 0.0, ssX, minX, maxX) + size.getX() / 2.0;
                    y = MathUtil.map((double)(-dataPoint.y[i]), 0.0, ssY, minY, maxY) + size.getY() / 2.0;
                    break;
                }
                case X_TIME: 
                case Y_TIME: {
                    x = MathUtil.map(1.0 / (double)len * (double)i + (double)time, 0.0, (double)this.timeWindow, minX, maxX);
                    double val = this.mode == Mode.X_TIME ? (double)dataPoint.x[i] : (double)dataPoint.y[i];
                    y = MathUtil.map(-val, 0.0, ssY, minY, maxY) + size.getY() / 2.0;
                    break;
                }
                default: {
                    y = 0.0;
                    x = 0.0;
                }
            }
            list.addLast(new Vector2D(x, y));
        }
        return list;
    }

    @Override
    public void render(Vector2D mouse) {
        this.updateDataPoints();
        boolean isInMainGui = Objects.equals(Minecraft.getCurrentGuiScreen(), "main_gui");
        if (!this.fullScreen || isInMainGui) {
            long latestTime;
            Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.selected ? this.selectedColor : Theme.lightBackground, Theme.lightEdge);
            long l = latestTime = this.dataPoints.size() == 0 ? 0L : this.dataPoints.getFirst().tickTime;
            if (latestTime - this.displayTime >= (long)this.timeWindow) {
                double size = (double)this.timeWindow / (double)(latestTime - this.startTime) * (this.getDisplayedSize().getX() - 2.0);
                double pos = MathUtil.map(this.displayTime, this.startTime, latestTime - (long)this.timeWindow, this.getDisplayedPos().getX() + 1.0, this.getDisplayedPos().getX() + this.getDisplayedSize().getX() - size - 1.0);
                Renderer2D.drawRect(new Vector2D(pos, this.getDisplayedPos().getY() + this.getDisplayedSize().getY() - 1.0), new Vector2D(size, 1.0), Color.RED);
            }
        }
        if (this.renderPoints != null && this.renderPoints.size() > 1) {
            boolean shouldScissor;
            boolean bl = shouldScissor = !this.fullScreen && this.mode != Mode.X_Y && (!isInMainGui || !Keyboard.getPressedButtons().contains(340));
            if (shouldScissor) {
                Renderer2D.enableScissor(this.getDisplayedPos().getX() + 1.0, this.getDisplayedPos().getY() + 1.0, this.getDisplayedSize().getX() - 2.0, this.getDisplayedSize().getY() - 2.0);
            }
            Renderer2D.drawLines(this.renderPoints, Color.RED);
            if (shouldScissor) {
                Renderer2D.disableScissor();
            }
        }
    }

    protected void updateDataPoints() {
        int movementCount;
        if (this.lastTick == API.tickTime) {
            return;
        }
        Player p = Player.getLatest();
        Player bp = Player.getBeforeLatest();
        if (p == null || bp == null) {
            return;
        }
        if (bp.timingInput.isStopTick() && bp.deltaMouseX.length == 0 && (!p.timingInput.isStopTick() || p.deltaMouseX.length != 0)) {
            this.dataPoints.clear();
            this.renderPoints.clear();
            this.startTime = this.displayTime = API.tickTime - 1L;
            this.dataPoints.addFirst(new DataPoint(API.tickTime - 1L));
            for (Vector2D v : this.dataToRenderPoint(this.dataPoints.getFirst())) {
                this.renderPoints.addFirst(v);
            }
        }
        if ((movementCount = p.deltaMouseX.length) == 0) {
            return;
        }
        int x = this.dataPoints.getFirst().x[this.dataPoints.getFirst().x.length - 1];
        int y = this.dataPoints.getFirst().y[this.dataPoints.getFirst().y.length - 1];
        DataPoint dataPoint = new DataPoint(new int[movementCount], new int[movementCount], API.tickTime);
        for (int i = 0; i < movementCount; ++i) {
            dataPoint.x[i] = x += p.deltaMouseX[i];
            dataPoint.y[i] = y += p.deltaMouseY[i];
        }
        if (this.displayTime < API.tickTime - (long)this.timeWindow) {
            this.displayTime = API.tickTime - (long)this.timeWindow;
            if (this.mode != Mode.X_Y) {
                this.reloadRenderPoints();
            }
        }
        this.dataPoints.addFirst(dataPoint);
        for (Vector2D v : this.dataToRenderPoint(dataPoint)) {
            this.renderPoints.addFirst(v);
        }
        this.lastTick = API.tickTime;
    }

    @Override
    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        menu.addComponent(new TextCheckButton(Vector2D.OFFSCREEN.copy(), "Fullscreen", this.fullScreen, this::setFullScreen));
        Button b = new Button("Mode: " + this.mode.name());
        b.setButtonCallback(mouseButton -> {
            if (mouseButton != Mouse.Button.LEFT && mouseButton != Mouse.Button.RIGHT) {
                return;
            }
            this.mode = Mode.values()[(this.mode.ordinal() - (mouseButton.value * 2 - 1) + Mode.values().length) % Mode.values().length];
            this.reloadRenderPoints();
            b.setText("Mode: " + this.mode.name());
        });
        menu.addComponent(b);
        menu.addComponent(new NumberSlider(1.0, Player.maxSavedTicks, 1.0, this.timeWindow, Vector2D.OFFSCREEN.copy(), new Vector2D(1.0, 12.0), newValue -> {
            this.timeWindow = (int)newValue;
            this.reloadRenderPoints();
        }));
        menu.addComponent(new Button("Delete", mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).removeComponent(this);
                menu.close();
            }
        }));
        return menu;
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (!this.contains(mousePos)) {
            return false;
        }
        this.displayTime = (long)MathUtil.constrain((float)this.displayTime + Math.signum(delta), this.startTime, Math.max(this.startTime, this.dataPoints.getFirst().tickTime - (long)this.timeWindow));
        this.reloadRenderPoints();
        return true;
    }

    protected static class DataPoint {
        public int[] x;
        public int[] y;
        public long tickTime;

        public DataPoint(long tickTime) {
            this(new int[]{0}, new int[]{0}, tickTime);
        }

        public DataPoint(int[] x, int[] y, long tickTime) {
            this.x = x;
            this.y = y;
            this.tickTime = tickTime;
        }
    }

    public static enum Mode {
        X_Y,
        X_TIME,
        Y_TIME;

    }
}

