/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.TickThread;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.ComponentHolder;
import io.github.kurrycat.mpkmod.gui.components.Div;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.Label;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.gui.infovars.InfoVar;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Colors;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class InfoLabel
extends Label
implements TickThread.Tickable {
    private InfoString infoString;
    private volatile String formattedText = "";

    @JsonCreator
    public InfoLabel(@JsonProperty(value="text") String text) {
        super(text);
        this.infoString = new InfoString(text);
    }

    public void updateText(String text) {
        this.text = text;
        this.infoString = new InfoString(text);
    }

    @Override
    public void render(Vector2D mouse) {
        this.drawDefaultSelectedBackground();
        FontRenderer.drawString(this.getFormattedText(), this.getDisplayedPos(), this.color, this.fontSize, true);
    }

    public String getFormattedText() {
        return this.formattedText;
    }

    @Override
    protected Vector2D getTextSize() {
        return FontRenderer.getStringSize(this.getFormattedText(), this.fontSize);
    }

    @Override
    public void tick() {
        this.formattedText = this.infoString.get();
        this.setSize(this.getTextSize());
    }

    @Override
    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        EditPane editPane = new EditPane();
        menu.addComponent(new Button("Edit", mouseButton -> {
            if (mouseButton != Mouse.Button.LEFT) {
                return;
            }
            ((MainGuiScreen)menu.paneHolder).passPositionTo(editPane, 4, Anchor.CENTER);
            ((MainGuiScreen)menu.paneHolder).openPane(editPane);
            menu.close();
        }));
        menu.addComponent(new NumberSlider(2.0, 30.0, 1.0, this.fontSize, Vector2D.OFFSCREEN, new Vector2D(56.0, 11.0), v -> {
            this.fontSize = v;
        }));
        menu.addComponent(new Button("Delete", mouseButton -> {
            if (mouseButton != Mouse.Button.LEFT) {
                return;
            }
            ((MainGuiScreen)menu.paneHolder).removeComponent(this);
            menu.close();
        }));
        return menu;
    }

    public class EditPane
    extends Pane<MainGuiScreen> {
        private final TextRectangle label;

        public EditPane() {
            super(Vector2D.ZERO, new Vector2D(0.5, 40.0));
            this.label = new TextRectangle(new Vector2D(0.0, 1.0), new Vector2D(1.0, 20.0), "", new Color(0, 0, 0, 0), Color.WHITE);
            this.addChild(this.label, 4, Anchor.TOP_CENTER);
            InputField inputField = new InputField(InfoLabel.this.text, new Vector2D(0.0, 5.0), 0.9).setOnContentChange(content -> InfoLabel.this.updateText(content.getContent()));
            this.addChild(inputField, 4, Anchor.BOTTOM_CENTER);
            ColorList cl = new ColorList(inputField);
            cl.setAbsolute(true);
            this.addChild(cl);
            InfoVarList vl = new InfoVarList(inputField, new Vector2D(5.0, 5.0), new Vector2D(0.2222222222222222, -10.0));
            vl.setAbsolute(true);
            this.addChild(vl, 4, Anchor.TOP_RIGHT);
            vl.bottomCover.setHeight(35.0, false);
            vl.bottomCover.addChild(new TextRectangle(new Vector2D(0.0, 5.0), new Vector2D(1.0, 14.0), "Filter", null, Color.WHITE), 4, Anchor.TOP_CENTER);
            vl.bottomCover.addChild(new InputField(new Vector2D(0.0, 5.0), 0.9).setOnContentChange(c -> vl.updateSearchFilter(c.getContent())), 4, Anchor.BOTTOM_CENTER);
        }

        @Override
        public void render(Vector2D mousePos) {
            this.label.setText(InfoLabel.this.getFormattedText());
            super.render(mousePos);
        }
    }

    private static class ColorItem
    extends ScrollableListItem<ColorItem> {
        public ColorItem(ScrollableList<ColorItem> parent, InputField inputField, Colors color) {
            super(parent);
            this.setHeight(12.0);
            Button button = new Button(color.getCode() + color.getName(), new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0), mouseButton -> {
                inputField.typeContentAtCursor("{" + color.getName() + "}");
                inputField.focus();
            });
            button.normalColor = Theme.NONE;
            this.addChild(button, 12);
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            this.renderComponents(mouse);
        }
    }

    private static class ColorList
    extends ScrollableList<ColorItem> {
        public ColorList(InputField inputField) {
            this.setTitle("Colors");
            this.setPos(new Vector2D(5.0, 5.0));
            double width = Arrays.stream(Colors.values()).map(c -> FontRenderer.getStringSize(c.getName()).getX()).max(Comparator.naturalOrder()).orElse(50.0);
            this.setSize(new Vector2D(width + 15.0, -10.0));
            for (Colors c2 : Colors.values()) {
                this.addItem(new ColorItem(this, inputField, c2));
            }
        }
    }

    private static class InfoVarComponent
    extends Component
    implements MouseInputListener {
        private final InfoVar infoVar;
        private final InputField inputField;
        private final ArrayList<InfoVarComponent> children = new ArrayList();
        private final Button collapseButton;
        private final Button addButton;
        private final boolean showCollapseButton;
        public boolean collapsed = true;
        private InfoVarComponent parent = null;

        public InfoVarComponent(InfoVar infoVar, InputField inputField) {
            this.infoVar = infoVar;
            this.inputField = inputField;
            double[] i = new double[]{18.0};
            infoVar.getEntries().stream().map(entry -> new InfoVarComponent((InfoVar)entry.getValue(), inputField)).forEach(c -> {
                c.parent = this;
                c.setSize(new Vector2D(-4.0, 18.0));
                c.setPos(new Vector2D(2.0, i[0] + 2.0));
                i[0] = i[0] + (double)c.getHeight();
                this.passPositionTo((ComponentHolder)c, 0, Anchor.TOP_RIGHT);
                this.children.add((InfoVarComponent)c);
            });
            this.showCollapseButton = this.children.size() > 0;
            TextRectangle text = new TextRectangle(Vector2D.ZERO, new Vector2D(1.0, 18.0), infoVar.getName(), new Color(0, 0, 0, 0), Color.WHITE);
            text.edgeColor = ScrollableListItem.defaultEdgeColor;
            text.leftAligned = true;
            this.addChild(text, 4);
            Div buttonHolder = new Div();
            buttonHolder.setSize(new Vector2D(1.0, 18.0));
            this.passPositionTo(buttonHolder, 4);
            this.collapseButton = new Button("v", new Vector2D(13.0, 0.0), new Vector2D(11.0, 11.0));
            this.collapseButton.setButtonCallback(mouseButton -> {
                if (mouseButton != Mouse.Button.LEFT) {
                    return;
                }
                this.setCollapsed(!this.collapsed);
            });
            buttonHolder.passPositionTo(this.collapseButton, 0, Anchor.CENTER_RIGHT);
            this.components.add(this.collapseButton);
            this.addButton = new Button("+", new Vector2D(1.0, 0.0), new Vector2D(11.0, 11.0));
            this.addButton.textOffset = new Vector2D(0.0, 1.0);
            this.addButton.setButtonCallback(mouseButton -> {
                if (mouseButton != Mouse.Button.LEFT) {
                    return;
                }
                inputField.typeContentAtCursor("{" + infoVar.getFullName() + "}");
                inputField.focus();
            });
            buttonHolder.passPositionTo(this.addButton, 0, Anchor.CENTER_RIGHT);
            this.components.add(this.addButton);
        }

        private void setCollapsed(boolean collapsed) {
            if (collapsed == this.collapsed) {
                return;
            }
            this.collapsed = collapsed;
            this.collapseButton.setText(collapsed ? "v" : "^");
            Vector2D vector2D = this.collapseButton.textOffset = collapsed ? Vector2D.ZERO.copy() : new Vector2D(0.0, 3.0);
            if (this.parent != null) {
                this.parent.updateChildPositions();
            }
            if (collapsed) {
                for (InfoVarComponent c : this.children) {
                    c.setCollapsed(true);
                }
            }
        }

        public boolean searchAndOpenString(String searchString) {
            if (Objects.equals(searchString, "")) {
                this.setCollapsed(true);
            }
            if (this.infoVar.getName().toLowerCase().contains(searchString.toLowerCase())) {
                return true;
            }
            boolean result = false;
            for (InfoVarComponent c : this.children) {
                if (!c.searchAndOpenString(searchString)) continue;
                result = true;
            }
            this.setCollapsed(!result);
            return result;
        }

        private void updateChildPositions() {
            double[] i = new double[]{18.0};
            this.children.forEach(c -> {
                c.setPos(new Vector2D(2.0, i[0] + 2.0));
                i[0] = i[0] + (double)c.getHeight();
            });
            if (this.parent != null) {
                this.parent.updateChildPositions();
            }
        }

        @Override
        public void render(Vector2D mouse) {
            for (Component c2 : this.components) {
                if (!this.showCollapseButton && c2 == this.collapseButton) continue;
                c2.render(mouse);
            }
            if (!this.collapsed) {
                this.children.forEach(c -> c.render(mouse));
            }
        }

        public int getHeight() {
            return 18 + (this.collapsed ? 0 : this.children.stream().map(InfoVarComponent::getHeight).reduce(0, Integer::sum) + 4);
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            return this.addButton.handleMouseInput(state, mousePos, button) || this.showCollapseButton && this.collapseButton.handleMouseInput(state, mousePos, button) || !this.collapsed && ItrUtil.orMap(this.children, c -> c.handleMouseInput(state, mousePos, button));
        }
    }

    private static class InfoVarListItem
    extends ScrollableListItem<InfoVarListItem> {
        public static final int HEIGHT = 18;
        private final InfoVarComponent infoVarComponent;

        public InfoVarListItem(InfoVarList parent, InfoVar infoVar) {
            super(parent);
            this.setHeight(18.0);
            this.infoVarComponent = new InfoVarComponent(infoVar, parent.inputField);
            this.infoVarComponent.setSize(new Vector2D(1.0, -18.0));
            this.passPositionTo(this.infoVarComponent, 4);
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            this.infoVarComponent.render(mouse);
        }

        @Override
        public int getHeight() {
            return this.infoVarComponent.getHeight();
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            return this.infoVarComponent.handleMouseInput(state, mousePos, button) || super.handleMouseInput(state, mousePos, button);
        }

        public boolean containsSearchString(String searchString) {
            return this.infoVarComponent.searchAndOpenString(searchString);
        }
    }

    private static class InfoVarList
    extends ScrollableList<InfoVarListItem> {
        private final List<InfoVarListItem> allItems;
        private final InputField inputField;

        public InfoVarList(InputField inputField, Vector2D pos, Vector2D size) {
            this.setPos(pos);
            this.setSize(size);
            this.setTitle("Variables");
            this.inputField = inputField;
            this.allItems = Main.infoTree.getEntries().stream().map(entry -> new InfoVarListItem(this, (InfoVar)entry.getValue())).collect(Collectors.toList());
            this.updateSearchFilter("");
        }

        public void updateSearchFilter(String searchString) {
            this.items.clear();
            for (InfoVarListItem item : this.allItems) {
                if (!item.containsSearchString(searchString)) continue;
                this.items.add(item);
            }
        }

        @Override
        public void render(Vector2D mouse) {
            super.render(mouse);
            this.renderComponents(mouse);
        }
    }
}

