/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class Label
extends Component {
    @Option.Field(showInOptionList=false)
    public static double DEFAULT_FONT_SIZE = FontRenderer.DEFAULT_FONT_SIZE;
    @JsonProperty
    public String text;
    @JsonProperty(value="fontSize")
    public double fontSize = DEFAULT_FONT_SIZE;
    @JsonProperty
    public Color color = Color.WHITE;
    @JsonProperty
    public Color selectedColor = new Color(255, 170, 0, 100);
    public Color backgroundColor = null;

    public Label(String text) {
        this.text = text;
    }

    public Label(String text, Vector2D pos) {
        this.setPos(pos);
        this.text = text;
    }

    @Override
    public void render(Vector2D mouse) {
        this.drawDefaultSelectedBackground();
        if (this.backgroundColor != null) {
            Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.backgroundColor);
        }
        FontRenderer.drawString(this.text, this.getDisplayedPos(), this.color, this.fontSize, true);
    }

    public void drawDefaultSelectedBackground() {
        if (this.selected) {
            Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.selectedColor);
            Renderer2D.drawHollowRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, Color.BLACK);
        }
        if (this.highlighted) {
            Renderer2D.drawDottedRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, 1.0, 1.0, Color.BLACK);
        }
    }

    protected Vector2D getTextSize() {
        return FontRenderer.getStringSize(this.text, this.fontSize);
    }

    @JsonProperty
    public Label setText(String text) {
        this.text = text;
        this.setSize(this.getTextSize());
        return this;
    }

    @JsonProperty
    public Label setColor(Color color) {
        this.color = color;
        return this;
    }
}

