/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.util.ColorUtil;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class MessageQueue
extends ResizableComponent {
    private final String name;
    @JsonProperty
    private final String messageReceiverID = "offset";
    @JsonProperty
    public Color backgroundColor = new Color(100, 100, 100, 40);
    @JsonProperty
    public Color messageBackgroundColor = new Color(31, 31, 31, 47);
    @JsonProperty
    public Color messageHighlightBackgroundColor = new Color(98, 255, 74, 157);
    @JsonProperty
    public Color messageColor = new Color(255, 255, 255, 255);
    @JsonProperty
    public Color edgeColor = new Color(100, 100, 100, 50);
    public Color selectedColor = new Color(255, 170, 0, 100);
    private ArrayList<Message> messages = new ArrayList();

    @JsonCreator
    public MessageQueue(@JsonProperty(value="displayName") String name) {
        this.name = name;
        this.setMinSize(new Vector2D(40.0, 22.0));
    }

    public static MessageQueue getReceiverFor(String receiverID, ArrayList<MessageQueue> queuesToSearch) {
        return queuesToSearch.stream().filter(messageQueue -> messageQueue.messageReceiverID.equals(receiverID)).findFirst().orElse(null);
    }

    @Override
    public void render(Vector2D mouse) {
        Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.selected ? this.selectedColor : this.backgroundColor, this.edgeColor);
        if (this.highlighted) {
            Renderer2D.drawDottedRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, 1.0, 1.0, Color.BLACK);
        }
        this.messages = this.messages.stream().filter(Message::isAlive).collect(Collectors.toCollection(ArrayList::new));
        double lineHeight = 10.0;
        for (int i = 0; i < this.messages.size() && (double)(i + 1) * lineHeight <= this.getDisplayedSize().getY() - 2.0; ++i) {
            this.messages.get(i).render(new Vector2D(this.getDisplayedPos().getX() + 1.0, this.getDisplayedPos().getY() + this.getDisplayedSize().getY() - (double)(i + 1) * lineHeight - 1.0), new Vector2D(this.getDisplayedSize().getX() - 2.0, lineHeight));
        }
        this.renderHoverEdges(mouse);
    }

    public void postMessage(String content, boolean highlighted) {
        Message message = new Message(this, content);
        if (highlighted) {
            message.highlight();
        }
        this.messages.add(0, message);
    }

    @JsonGetter(value="displayName")
    public String getName() {
        return this.name;
    }

    public static class Message {
        public String content;
        public Instant created;
        public MessageQueue parent;
        public boolean highlighted = false;
        public int maxAge = 10000;
        public int fadeOutTime = 1000;

        public Message(MessageQueue parent, String content) {
            this.parent = parent;
            this.content = content;
            this.created = Instant.now();
        }

        public void render(Vector2D pos, Vector2D size) {
            long age = this.getAge();
            double fadeOutAlpha = age < (long)(this.maxAge - this.fadeOutTime) ? 255.0 : MathUtil.map((long)this.maxAge - Math.min(age, (long)this.maxAge), (double)this.fadeOutTime, 0.0, 255.0, 0.0);
            Color backgroundColor = this.highlighted ? this.parent.messageHighlightBackgroundColor : this.parent.messageBackgroundColor;
            Renderer2D.drawRect(pos, size, ColorUtil.withAlpha(backgroundColor, Math.min(fadeOutAlpha, (double)backgroundColor.getAlpha())));
            FontRenderer.drawCenteredString(this.content, pos.add(size.div(2.0)).add(0.0, 1.0), ColorUtil.withAlpha(this.parent.messageColor, fadeOutAlpha), false);
        }

        public boolean isAlive() {
            return this.getAge() <= (long)this.maxAge;
        }

        public long getAge() {
            return ChronoUnit.MILLIS.between(this.created, Instant.now());
        }

        public void highlight() {
            this.highlighted = true;
        }
    }
}

