/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.WorldInteraction;
import io.github.kurrycat.mpkmod.gui.ComponentScreen;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.CheckButton;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.landingblock.LandingBlock;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Pair;
import io.github.kurrycat.mpkmod.util.Vector2D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class LandingBlockGuiScreen
extends ComponentScreen {
    public static List<LandingBlock> lbs = new ArrayList<LandingBlock>();
    public static Color lbListColorItemEdge = new Color(255, 255, 255, 95);
    public static Color lbListColorBg = new Color(31, 31, 31, 150);
    private LBList lbList;

    public static List<Vector3D> calculateLBOffsets() {
        ArrayList<Vector3D> returnOffsets = new ArrayList<Vector3D>();
        lbs.forEach(lb -> {
            Vector3D o = lb.saveOffsetIfInRange();
            if (o != null) {
                returnOffsets.add(o);
            }
        });
        return returnOffsets;
    }

    @Override
    public boolean shouldCreateKeyBind() {
        return true;
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        this.lbList = new LBList(new Vector2D(0.0, 0.05), new Vector2D(0.6, 0.9));
        this.addChild(this.lbList, 15, Anchor.TOP_CENTER);
        this.lbList.topCover.addChild(new Button("x", new Vector2D(5.0, 1.0), new Vector2D(11.0, 11.0), mouseButton -> this.close()), 0, Anchor.CENTER_RIGHT);
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        for (LBListItem item : this.lbList.getItems()) {
            item.landingBlock.highlight = false;
        }
    }

    @Override
    public void render(Vector2D mouse, float partialTicks) {
        super.render(mouse, partialTicks);
    }

    public static class LBListItem
    extends ScrollableListItem<LBListItem> {
        public CheckButton enabled;
        public LandingBlock landingBlock;
        public InputField minX;
        public InputField minY;
        public InputField minZ;
        public InputField maxX;
        public InputField maxY;
        public InputField maxZ;
        public InputField[] fields;
        public boolean collapsed = true;
        public Button collapseButton;
        public Button deleteButton;
        public Button landingModeButton;

        public LBListItem(ScrollableList<LBListItem> parent, LandingBlock landingBlock) {
            super(parent);
            this.landingBlock = landingBlock;
            this.enabled = new CheckButton(Vector2D.ZERO, checked -> {
                landingBlock.enabled = checked;
            });
            this.enabled.setChecked(landingBlock.enabled);
            this.minX = new InputField(String.valueOf(landingBlock.boundingBox.getMin().getX()), Vector2D.OFFSCREEN, 25.0, true).setName("minX: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMinX(c.getNumber());
                }
            });
            this.minY = new InputField(String.valueOf(landingBlock.boundingBox.getMin().getY()), Vector2D.OFFSCREEN, 25.0, true).setName("minY: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMinY(c.getNumber());
                }
            });
            this.minZ = new InputField(String.valueOf(landingBlock.boundingBox.getMin().getZ()), Vector2D.OFFSCREEN, 25.0, true).setName("minZ: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMinZ(c.getNumber());
                }
            });
            this.maxX = new InputField(String.valueOf(landingBlock.boundingBox.getMax().getX()), Vector2D.OFFSCREEN, 25.0, true).setName("maxX: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMaxX(c.getNumber());
                }
            });
            this.maxY = new InputField(String.valueOf(landingBlock.boundingBox.getMax().getY()), Vector2D.OFFSCREEN, 25.0, true).setName("maxY: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMaxY(c.getNumber());
                }
            });
            this.maxZ = new InputField(String.valueOf(landingBlock.boundingBox.getMax().getZ()), Vector2D.OFFSCREEN, 25.0, true).setName("maxZ: ").setOnContentChange(c -> {
                if (c.getNumber() != null) {
                    landingBlock.boundingBox.setMaxZ(c.getNumber());
                }
            });
            this.fields = new InputField[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
            this.collapseButton = new Button("v", Vector2D.OFFSCREEN, new Vector2D(11.0, 11.0), mouseButton -> {
                if (mouseButton == Mouse.Button.LEFT) {
                    this.collapsed = !this.collapsed;
                }
            });
            this.deleteButton = new Button("x", Vector2D.OFFSCREEN, new Vector2D(11.0, 11.0), mouseButton -> {
                if (mouseButton == Mouse.Button.LEFT) {
                    lbs.remove(landingBlock);
                    parent.items.remove(this);
                }
            });
            this.deleteButton.textColor = Color.RED;
            this.deleteButton.pressedTextColor = Color.RED;
            this.landingModeButton = new Button("", Vector2D.OFFSCREEN, Vector2D.ZERO, mouseButton -> {
                if (mouseButton == Mouse.Button.LEFT) {
                    landingBlock.landingMode = landingBlock.landingMode.getNext();
                } else if (Mouse.Button.RIGHT.equals((Object)mouseButton)) {
                    switch (landingBlock.landingMode) {
                        case Z_NEO: {
                            landingBlock.boundingBox.setMinZ(landingBlock.boundingBox.getMin().getZ() + 0.6);
                            landingBlock.boundingBox.setMaxZ(landingBlock.boundingBox.getMax().getZ() - 0.6);
                            break;
                        }
                        case ENTER: {
                            landingBlock.boundingBox.setMaxX((double)((int)landingBlock.boundingBox.getMin().getX()) + 0.7);
                            landingBlock.boundingBox.setMaxZ((double)((int)landingBlock.boundingBox.getMin().getZ()) + 0.7);
                            landingBlock.boundingBox.setMinX((double)((int)landingBlock.boundingBox.getMin().getX()) + 0.3);
                            landingBlock.boundingBox.setMinZ((double)((int)landingBlock.boundingBox.getMin().getZ()) + 0.3);
                        }
                    }
                }
            });
        }

        @Override
        public int getHeight() {
            return this.collapsed ? 21 : 50;
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            Renderer2D.drawRectWithEdge(pos, size, 1.0, lbListColorBg, lbListColorItemEdge);
            if (this.collapsed) {
                FontRenderer.drawString(this.landingBlock.boundingBox.getMin() + " - " + this.landingBlock.boundingBox.getMax(), pos.add(size.div(2.0)).sub(0.0, FontRenderer.getStringSize(this.landingBlock.boundingBox.getMin() + " - " + this.landingBlock.boundingBox.getMax()).getY() / 2.0 - 1.0).sub(FontRenderer.getStringSize(this.landingBlock.boundingBox.getMin() + " ").getX(), 0.0).sub(FontRenderer.getStringSize("-").getX() / 2.0, 0.0), Color.WHITE, false);
            } else {
                for (int i = 0; i < this.fields.length; ++i) {
                    this.fields[i].setPos(pos.add(size.getX() / 12.0 + size.getX() / 5.0 * 2.0 * (double)(i / 3), size.getY() / 4.0 * (double)(1 + i % 3) - this.fields[i].getDisplayedSize().getY() / 2.0));
                    this.fields[i].setWidth(size.getX() / 3.0, false);
                    this.fields[i].render(mouse);
                }
            }
            this.enabled.setPos(pos.add(size.getX() / 16.0 - this.enabled.getDisplayedSize().getX(), size.getY() / 2.0 - 5.5).round());
            this.enabled.render(mouse);
            this.collapseButton.setText(this.collapsed ? "v" : "^");
            this.collapseButton.textOffset = this.collapsed ? Vector2D.ZERO : new Vector2D(0.0, 3.0);
            this.collapseButton.setPos(pos.add(size.getX() - size.getX() / 16.0, size.getY() / (double)(this.collapsed ? 2 : 3) - 5.5).round());
            this.collapseButton.render(mouse);
            this.deleteButton.setPos(pos.add(size.getX() - size.getX() / 8.0, size.getY() / (double)(this.collapsed ? 2 : 3) - 5.5).round());
            this.deleteButton.render(mouse);
            this.landingModeButton.setPos(pos.add(size.getX() - size.getX() / 8.0, size.getY() / 3.0 * 2.0 - 5.5).round());
            this.landingModeButton.setSize(new Vector2D(size.getX() / 16.0 + this.collapseButton.getDisplayedSize().getX(), 11.0));
            this.landingModeButton.enabled = !this.collapsed;
            this.landingModeButton.setText(this.landingBlock.landingMode.toString());
            if (!this.collapsed) {
                this.landingModeButton.render(mouse);
            }
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            return ItrUtil.orMapAll(this.collapsed ? ItrUtil.getAllOfType(MouseInputListener.class, this.enabled, this.collapseButton, this.deleteButton, this.landingModeButton) : ItrUtil.getAllOfType(MouseInputListener.class, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.enabled, this.collapseButton, this.deleteButton, this.landingModeButton), ele -> ele.handleMouseInput(state, mousePos, button));
        }

        @Override
        public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
            return !this.collapsed && ItrUtil.orMapAll(ItrUtil.getAllOfType(KeyInputListener.class, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ), ele -> ele.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
        }
    }

    public static class LBList
    extends ScrollableList<LBListItem> {
        public LBList(Vector2D pos, Vector2D size) {
            this.setPos(pos);
            this.setSize(size);
            this.setTitle("Landing Blocks");
            this.updateList();
            Button addLB = new Button("Add LB", new Vector2D(0.0, 0.0), new Vector2D(40.0, 20.0), mouseButton -> {
                if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                    Vector3D lookingAt = WorldInteraction.getLookingAt();
                    if (lookingAt != null) {
                        lbs.add(new LandingBlock(new BoundingBox3D(lookingAt, lookingAt.add(1.0))));
                    } else if (Player.getLatest() != null) {
                        lbs.add(new LandingBlock(BoundingBox3D.asBlockPos(Player.getLatest().getPos())));
                    } else {
                        lbs.add(new LandingBlock(new BoundingBox3D(new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.0, 0.0, 0.0))));
                    }
                    this.items.add(new LBListItem(this, lbs.get(lbs.size() - 1)));
                }
            });
            this.bottomCover.setHeight(24.0, false);
            this.bottomCover.backgroundColor = null;
            this.bottomCover.addChild(addLB, 0, Anchor.CENTER);
        }

        public void updateList() {
            this.items.clear();
            for (LandingBlock lb : lbs) {
                this.items.add(new LBListItem(this, lb));
            }
        }

        @Override
        public void render(Vector2D mouse) {
            super.render(mouse);
            for (LBListItem item : this.getItems()) {
                item.landingBlock.highlight = false;
            }
            Pair p = this.getItemAndRelMousePosUnderMouse(mouse);
            if (p != null) {
                ((LBListItem)p.first).landingBlock.highlight = true;
            }
            this.components.forEach(c -> c.render(mouse));
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            return super.handleMouseInput(state, mousePos, button);
        }
    }
}

