/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;

public class Line2D {
    public Vector2D p1;
    public Vector2D p2;

    public Line2D(Vector2D p1, Vector2D p2) {
        this.p1 = p2.getX() < p1.getX() ? p2 : p1;
        this.p2 = p2.getX() < p1.getX() ? p1 : p2;
    }

    public double length() {
        return this.p2.sub(this.p1).length();
    }

    public double distanceToPos(Vector2D pos) {
        if (this.p1.equals(this.p2)) {
            return this.p1.dist(pos);
        }
        Vector2D len = this.p2.sub(this.p1);
        double t = len.dot(pos.sub(this.p1)) / len.lengthSqr();
        double cT = MathUtil.constrain(t, 0.0, 1.0);
        Vector2D pOnLine = this.p1.add(len.mult(cT));
        return pOnLine.dist(pos);
    }
}

