/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.discord;

import io.github.kurrycat.mpkmod.compatibility.API;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DiscordNativeLibrary {
    public static final String DISCORD_GAME_SDK_URL = "https://dl-game-sdk.discordapp.net/2.5.6/discord_game_sdk.zip";
    public static final String DISCORD_FILE_NAME = "discord_game_sdk";

    private static String getLibPath() throws RuntimeException {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (arch.equals("amd64")) {
            arch = "x86_64";
        }
        return arch + "/" + DISCORD_FILE_NAME + DiscordNativeLibrary.getSuffix();
    }

    private static String getSuffix() {
        String suffix;
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("windows")) {
            suffix = ".dll";
        } else if (osName.contains("linux")) {
            suffix = ".so";
        } else if (osName.contains("mac os")) {
            suffix = ".dylib";
        } else {
            throw new RuntimeException("Cannot determine OS type: " + osName);
        }
        return suffix;
    }

    public static File getNativeLibrary() {
        File lib = null;
        try {
            lib = DiscordNativeLibrary.openNativeLibraryFromResources();
        }
        catch (IOException e) {
            API.LOGGER.info(API.DISCORD_RPC_MARKER, "Could not load discord library from resources. Attempting to download...");
        }
        catch (RuntimeException e) {
            API.LOGGER.info(API.DISCORD_RPC_MARKER, e.getMessage());
        }
        try {
            lib = DiscordNativeLibrary.downloadNativeLibrary();
        }
        catch (IOException e) {
            API.LOGGER.info(API.DISCORD_RPC_MARKER, "Could not download discord library");
        }
        catch (RuntimeException e) {
            API.LOGGER.info(API.DISCORD_RPC_MARKER, e.getMessage());
        }
        return lib;
    }

    public static File openNativeLibraryFromResources() throws IOException, RuntimeException {
        return new File(DiscordNativeLibrary.getLibPath());
    }

    public static File downloadNativeLibrary() throws IOException, RuntimeException {
        ZipEntry entry;
        String zipPath = "lib/" + DiscordNativeLibrary.getLibPath();
        URL downloadUrl = new URL(DISCORD_GAME_SDK_URL);
        HttpURLConnection connection = (HttpURLConnection)downloadUrl.openConnection();
        connection.setRequestProperty("User-Agent", "discord-game-sdk4j");
        ZipInputStream zin = new ZipInputStream(connection.getInputStream());
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.getName().equals(zipPath)) {
                File tempDir = new File(System.getProperty("java.io.tmpdir"), "java-discord_game_sdk" + System.nanoTime());
                if (!tempDir.mkdir()) {
                    throw new IOException("Cannot create temporary directory");
                }
                tempDir.deleteOnExit();
                File temp = new File(tempDir, DISCORD_FILE_NAME + DiscordNativeLibrary.getSuffix());
                temp.deleteOnExit();
                Files.copy(zin, temp.toPath(), new CopyOption[0]);
                zin.close();
                return temp;
            }
            zin.closeEntry();
        }
        zin.close();
        return null;
    }
}

