/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.WorldInteraction;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.gui.components.TextCheckButton;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class BarrierDisplayComponent
extends ResizableComponent {
    @JsonProperty(value="fullscreen")
    boolean fullscreen = false;
    @JsonProperty(value="lineThickness")
    int lineThickness = 2;
    public Color selectedColor = new Color(255, 170, 0, 100);

    @Override
    public void render(Vector2D mouse) {
        Color color;
        String lookingAtBlock = WorldInteraction.getLookingAtBlock();
        boolean lookingAtBarrier = lookingAtBlock != null && lookingAtBlock.contains("minecraft:barrier");
        Color color2 = color = lookingAtBarrier ? Theme.warnText : Theme.defaultText;
        if (this.selected) {
            color = this.selectedColor;
        }
        String currentGui = Minecraft.getCurrentGuiScreen();
        if (lookingAtBarrier && this.fullscreen && currentGui == null) {
            Vector2D windowSize = Renderer2D.getScaledSize();
            Renderer2D.drawRect(Vector2D.ZERO, new Vector2D(windowSize.getX(), this.lineThickness), color);
            Renderer2D.drawRect(Vector2D.ZERO, new Vector2D(this.lineThickness, windowSize.getY()), color);
            Renderer2D.drawRect(Vector2D.ZERO.add(0.0, windowSize.getY() - (double)this.lineThickness), new Vector2D(windowSize.getX(), this.lineThickness), color);
            Renderer2D.drawRect(Vector2D.ZERO.add(windowSize.getX() - (double)this.lineThickness, 0.0), new Vector2D(this.lineThickness, windowSize.getY()), color);
        }
        if (lookingAtBarrier && !this.fullscreen || currentGui != null && currentGui.equals("main_gui")) {
            FontRenderer.drawCenteredString("!", this.getDisplayedPos().add(this.getDisplayedSize().div(2.0)).add(new Vector2D(0.0, 1.0)), color, false);
            Renderer2D.drawRect(this.getDisplayedPos().add(1.0, 0.0), new Vector2D(this.getDisplayedSize().getX() - 2.0, this.lineThickness), color);
            Renderer2D.drawRect(this.getDisplayedPos().add(0.0, 1.0), new Vector2D(this.lineThickness, this.getDisplayedSize().getY() - 2.0), color);
            Renderer2D.drawRect(this.getDisplayedPos().add(1.0, this.getDisplayedSize().getY() - (double)this.lineThickness), new Vector2D(this.getDisplayedSize().getX() - 2.0, this.lineThickness), color);
            Renderer2D.drawRect(this.getDisplayedPos().add(this.getDisplayedSize().getX() - (double)this.lineThickness, 1.0), new Vector2D(this.lineThickness, this.getDisplayedSize().getY() - 2.0), color);
        }
        if (this.highlighted) {
            Renderer2D.drawDottedRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, 1.0, 1.0, Color.BLACK);
        }
        this.renderHoverEdges(mouse);
    }

    @Override
    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        menu.addComponent(new TextCheckButton(Vector2D.OFFSCREEN, "Fullscreen", this.fullscreen, checked -> {
            this.fullscreen = checked;
        }));
        menu.addComponent(new NumberSlider(1.0, Math.floor(Math.min(this.getDisplayedSize().getX() / 2.0, this.getDisplayedSize().getY()) / 2.0), 1.0, this.lineThickness, Vector2D.OFFSCREEN, new Vector2D(56.0, 11.0), sliderValue -> {
            this.lineThickness = (int)sliderValue;
        }));
        menu.addComponent(new Button("Delete", mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).removeComponent(this);
                menu.close();
            }
        }));
        return menu;
    }
}

