/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.ColorUtil;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Arrays;
import java.util.function.Consumer;

public class ColorSelector
extends Component
implements KeyInputListener,
MouseInputListener,
MouseScrollListener {
    private final NumberSlider red;
    private final NumberSlider green;
    private final NumberSlider blue;
    private final NumberSlider alpha;
    private final InputField color;
    private final Consumer<Color> onChange;
    public Color backgroundColor = new Color(31, 31, 31, 150);
    private Color value;

    public ColorSelector(Color value, Vector2D pos, Consumer<Color> onChange) {
        this.setPos(pos);
        this.value = value;
        this.onChange = onChange;
        double width = 62.0;
        double currY = 1.0;
        this.red = new NumberSlider(0.0, 255.0, 1.0, value.getRed(), new Vector2D(1.0, currY), new Vector2D(width, 11.0), newValue -> this.sliderValueChanged(new Color((int)newValue, this.value.getGreen(), this.value.getBlue(), this.value.getAlpha())));
        this.passPositionTo(this.red, 0, Anchor.TOP_LEFT);
        this.green = new NumberSlider(0.0, 255.0, 1.0, value.getGreen(), new Vector2D(1.0, currY += this.red.getDisplayedSize().getY() + 1.0), new Vector2D(width, 11.0), newValue -> this.sliderValueChanged(new Color(this.value.getRed(), (int)newValue, this.value.getBlue(), this.value.getAlpha())));
        this.passPositionTo(this.green, 0, Anchor.TOP_LEFT);
        this.blue = new NumberSlider(0.0, 255.0, 1.0, value.getBlue(), new Vector2D(1.0, currY += this.green.getDisplayedSize().getY() + 1.0), new Vector2D(width, 11.0), newValue -> this.sliderValueChanged(new Color(this.value.getRed(), this.value.getGreen(), (int)newValue, this.value.getAlpha())));
        this.passPositionTo(this.blue, 0, Anchor.TOP_LEFT);
        this.alpha = new NumberSlider(0.0, 255.0, 1.0, value.getAlpha(), new Vector2D(1.0, currY += this.blue.getDisplayedSize().getY() + 1.0), new Vector2D(width, 11.0), newValue -> this.sliderValueChanged(new Color(this.value.getRed(), this.value.getGreen(), this.value.getBlue(), (int)newValue)));
        this.passPositionTo(this.alpha, 0, Anchor.TOP_LEFT);
        this.color = new InputField(ColorUtil.colorToHex(this.value), new Vector2D(1.0, (currY += this.alpha.getDisplayedSize().getY() + 1.0) + 3.0), width).setOnContentChange(content -> this.inputValueChanged(content.getContent())).setFilter(InputField.FILTER_HEX);
        this.passPositionTo(this.color, 0, Anchor.TOP_LEFT);
        this.setSize(new Vector2D(this.color.getDisplayedSize().getX() + 2.0, 1.0 + this.red.getDisplayedSize().getY() + 1.0 + this.green.getDisplayedSize().getY() + 1.0 + this.blue.getDisplayedSize().getY() + 1.0 + this.alpha.getDisplayedSize().getY() + 4.0 + this.color.getDisplayedSize().getY() + 1.0));
    }

    private void sliderValueChanged(Color value) {
        this.value = value;
        this.color.content = ColorUtil.colorToHex(value);
        this.onChange.accept(this.value);
    }

    private void inputValueChanged(String value) {
        Color c = ColorUtil.hexToColor(value);
        if (c != null) {
            this.value = c;
            this.red.setValue(c.getRed());
            this.green.setValue(c.getGreen());
            this.blue.setValue(c.getBlue());
            this.alpha.setValue(c.getAlpha());
            this.onChange.accept(this.value);
        }
    }

    @Override
    public void render(Vector2D mouse) {
        Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.backgroundColor, this.backgroundColor);
        this.red.render(mouse);
        this.green.render(mouse);
        this.blue.render(mouse);
        this.alpha.render(mouse);
        this.color.render(mouse);
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        return this.color.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped);
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        return ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseInputListener.class, this.red, this.green, this.blue, this.alpha, this.color), listener -> listener.handleMouseInput(state, mousePos, button));
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        return ItrUtil.orMapAll(Arrays.asList(this.red, this.green, this.blue, this.alpha), slider -> slider.handleMouseScroll(mousePos, delta));
    }
}

