/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.ComponentHolder;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.JSONPos2D;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;

public abstract class Component
extends ComponentHolder {
    public boolean selected = false;
    public boolean highlighted = false;
    protected Vector2D renderOffset = Vector2D.ZERO;

    @JsonCreator
    public Component() {
    }

    public abstract void render(Vector2D var1);

    public Component setRenderOffset(Vector2D renderOffset) {
        this.renderOffset = renderOffset.copy();
        return this;
    }

    public Vector2D getRenderOffset() {
        return this.renderOffset;
    }

    @JsonGetter(value="pos")
    public JSONPos2D getJsonPos() {
        return new JSONPos2D(this.pos, this.anchor, this.parentAnchor, this.percentFlag);
    }

    @JsonSetter(value="pos")
    public void setPosFromJson(JSONPos2D pos) {
        this.anchor = pos.getAnchor();
        this.parentAnchor = pos.getParentAnchor();
        this.percentFlag = pos.getPercentFlag();
        this.setPos(pos.getPos());
    }

    @JsonProperty(value="size")
    public Vector2D getSizeForJson() {
        return this.size;
    }

    @JsonProperty(value="size")
    public void setSizeForJson(Vector2D size) {
        this.size = size;
    }

    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        menu.addComponent(new Button("Delete", Vector2D.OFFSCREEN, new Vector2D(30.0, 11.0), mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).removeComponent(this);
                menu.close();
            }
        }));
        return menu;
    }

    public boolean contains(Vector2D testPos) {
        if (testPos == null) {
            return false;
        }
        if (this.getDisplayedPos() == null) {
            return false;
        }
        return Renderer2D.scissorContains(testPos) && testPos.isInRectBetween(this.getDisplayedPos(), this.getDisplayedPos().add(this.getDisplayedSize()));
    }

    @Override
    public Vector2D getDisplayedPos() {
        if (this.selected && this.renderOffset != null) {
            return super.getDisplayedPos().add(this.renderOffset);
        }
        return super.getDisplayedPos();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }
}

