/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Div
extends Component
implements MouseInputListener,
MouseScrollListener,
KeyInputListener {
    public Color backgroundColor = null;
    public Color borderColor = null;
    public Color textColor = null;
    private String text = null;
    private String[] lines = null;
    private boolean hasSetSizeX = false;
    private boolean hasSetSizeY = false;

    public Div() {
    }

    public Div(Vector2D pos, Vector2D size) {
        this.setPos(pos);
        this.setSize(size);
    }

    @Override
    public void updatePosAndSize() {
        super.updatePosAndSize();
        if (this.text != null) {
            if (!this.hasSetSizeX) {
                this.lines = new String[]{this.text};
            } else if (this.getDisplayedSize().getX() > 2.0) {
                Vector2D s = this.updateSplitLines();
                if (!this.hasSetSizeY) {
                    this.csize.set(s);
                }
            }
        }
    }

    @Override
    public void setSize(Vector2D size) {
        this.hasSetSizeX = size.getX() != this.size.getX();
        this.hasSetSizeY = size.getY() != this.size.getY();
        super.setSize(size);
    }

    private Vector2D updateSplitLines() {
        ArrayList<String> lines = new ArrayList<String>();
        double height = 2.0;
        double width = 0.0;
        Vector2D spaceSize = FontRenderer.getStringSize(" ");
        double spaceWidth = spaceSize.getX();
        double fontHeight = spaceSize.getY();
        for (String input : this.text.split("\n")) {
            StringTokenizer tok = new StringTokenizer(input, " ");
            StringBuilder line = new StringBuilder();
            double lineLen = 0.0;
            while (tok.hasMoreTokens()) {
                Vector2D vector2D;
                Vector2D size;
                String word = tok.nextToken();
                double maxWidth = this.getDisplayedSize().getX() - 2.0;
                while (true) {
                    Vector2D vector2D2;
                    size = FontRenderer.getStringSize(word);
                    if (!(vector2D2.getX() > maxWidth)) break;
                    if (lineLen != 0.0) {
                        lines.add(line.toString());
                        height += fontHeight;
                        width = Math.max(width, lineLen);
                        line = new StringBuilder();
                        lineLen = 0.0;
                    }
                    int maxLen = this.findLargestPossLenInLine(word, maxWidth);
                    lines.add(word.substring(0, maxLen));
                    height += fontHeight;
                    width = Math.max(width, size.getX());
                    word = word.substring(maxLen);
                }
                size = FontRenderer.getStringSize(word);
                if (lineLen + vector2D.getX() > maxWidth) {
                    lines.add(line.toString());
                    height += fontHeight;
                    width = Math.max(width, lineLen);
                    line = new StringBuilder();
                    lineLen = 0.0;
                }
                line.append(word).append(" ");
                lineLen += size.getX() + spaceWidth;
            }
            lines.add(line.toString());
            height += fontHeight;
            width = Math.max(width, FontRenderer.getStringSize(line.toString()).getX());
        }
        this.lines = lines.toArray(new String[0]);
        return new Vector2D(width, height);
    }

    private int findLargestPossLenInLine(String word, double lineWidth) {
        int min = 0;
        int max = word.length();
        while (min != max) {
            int mid = (min + max) / 2;
            if (FontRenderer.getStringSize(word.substring(0, mid)).getX() > lineWidth) {
                max = mid;
                continue;
            }
            min = mid;
        }
        return min;
    }

    public Div setMaxWidth(double width) {
        this.setSize(new Vector2D(width, this.size.getY()));
        return this;
    }

    public Div setText(String text) {
        this.text = text;
        this.setSize(this.size);
        return this;
    }

    public void addChildBelow(Component child) {
        this.addChild(child, 0, Anchor.TOP_LEFT);
        child.setPos(new Vector2D(1.0, this.getDisplayedSize().getY()));
        this.setSize(new Vector2D(Math.max(child.getDisplayedSize().getX() + 2.0, this.getDisplayedSize().getX()), this.getDisplayedSize().getY() + child.getDisplayedSize().getY() + 1.0));
    }

    @Override
    public void render(Vector2D mouse) {
        if (this.backgroundColor != null) {
            Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.backgroundColor);
        }
        if (this.borderColor != null) {
            Renderer2D.drawHollowRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.borderColor);
        }
        if (this.lines != null) {
            Vector2D pos = this.getDisplayedPos().add(3.0, 1.0);
            for (String line : this.lines) {
                FontRenderer.drawString(line, pos, this.textColor != null ? this.textColor : Color.WHITE, false);
                pos.addYInPlace(FontRenderer.getStringSize(line).getY());
            }
        }
        this.components.forEach(c -> c.render(mouse));
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        return ItrUtil.orMapAll(ItrUtil.getAllOfType(KeyInputListener.class, this.components), e -> e.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        return ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseInputListener.class, this.components), e -> e.handleMouseInput(state, mousePos, button));
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        return ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseScrollListener.class, this.components), e -> e.handleMouseScroll(mousePos, delta));
    }
}

