/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.PaneHolder;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.Colors;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class Pane<T extends PaneHolder>
extends Component
implements MouseInputListener,
MouseScrollListener,
KeyInputListener {
    public Color backgroundColor = Theme.darkBackground;
    public T paneHolder = null;
    private boolean loaded;

    public Pane(Vector2D pos, Vector2D size) {
        this.setPos(pos);
        this.setSize(size);
        this.loaded = false;
        this.addChild(this.createCloseButton(), 0, Anchor.TOP_RIGHT);
    }

    public Button createCloseButton() {
        return new Button("x", new Vector2D(1.0, 1.0), new Vector2D(10.0, 10.0), mouseButton -> this.close());
    }

    public void close() {
        if (this.paneHolder == null) {
            return;
        }
        this.paneHolder.closePane(this);
    }

    @Override
    public void render(Vector2D mousePos) {
        Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.backgroundColor);
        this.components.forEach(c -> c.render(mousePos));
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (this.loaded) {
            return ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseInputListener.class, this.components), b -> b.handleMouseInput(state, mousePos, button));
        }
        return false;
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (this.loaded) {
            return ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseScrollListener.class, this.components), b -> b.handleMouseScroll(mousePos, delta));
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setPaneHolder(T p) {
        this.paneHolder = p;
    }

    public void addTitle(String title) {
        TextRectangle titleRect = new TextRectangle(new Vector2D(0.0, 1.0), new Vector2D(1.0, 20.0), Colors.UNDERLINE.getCode() + title, new Color(0, 0, 0, 0), Color.WHITE);
        this.addChild(titleRect, 4, Anchor.TOP_CENTER);
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        if (this.loaded) {
            return ItrUtil.orMapAll(ItrUtil.getAllOfType(KeyInputListener.class, this.components), b -> b.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
        }
        return false;
    }
}

