/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.CheckButton;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class TextCheckButton
extends CheckButton {
    private String text;
    public Color color = Color.WHITE;
    private Vector2D checkboxSize = new Vector2D(11.0, 11.0);

    public TextCheckButton(Vector2D pos, String text, boolean checked, CheckButton.CheckButtonCallback checkButtonCallback) {
        super(pos, checked, checkButtonCallback);
        this.text = text;
    }

    @Override
    public void render(Vector2D mouse) {
        Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.checkboxSize, 1.0, this.normalColor, this.normalColor);
        if (this.isChecked()) {
            FontRenderer.drawString("x", this.getDisplayedPos().add(new Vector2D(3.0, 1.0)), Color.WHITE, false);
        }
        FontRenderer.drawString(this.text, this.getDisplayedPos().add(this.checkboxSize.getX() + 2.0, 2.0), this.color, true);
    }

    public String getText() {
        return this.text;
    }

    public TextCheckButton setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Vector2D getDisplayedSize() {
        Vector2D fontSize = FontRenderer.getStringSize(this.text);
        return new Vector2D(fontSize.getX() + 3.0 + this.checkboxSize.getX(), Math.max(fontSize.getY(), this.checkboxSize.getY()));
    }

    @Override
    public Vector2D getSizeForJson() {
        Vector2D fontSize = FontRenderer.getStringSize(this.text);
        return new Vector2D(fontSize.getX() + 3.0 + this.checkboxSize.getX(), Math.max(fontSize.getY(), this.checkboxSize.getY()));
    }

    public void setCheckboxSize(Vector2D checkboxSize) {
        this.checkboxSize = checkboxSize;
    }
}

