/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.infovars;

import io.github.kurrycat.mpkmod.gui.infovars.InfoVar;
import io.github.kurrycat.mpkmod.util.Debug;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InfoTree {
    private final HashMap<String, InfoVar> elements = new HashMap();
    private InfoTree parentTree = null;
    private InfoVar node = null;
    private int size = 0;

    public InfoTree() {
    }

    public InfoTree(InfoVar node) {
        this.node = node;
    }

    public void addElement(String name, InfoVar var) {
        if (name.contains(".")) {
            Debug.stacktrace("Expected String without \".\", got: \"" + name + "\"");
            return;
        }
        var.setParent(this);
        this.elements.put(name, var);
        ++this.size;
        if (this.parentTree != null) {
            ++this.parentTree.size;
        }
    }

    public Set<Map.Entry<String, InfoVar>> getEntries() {
        return this.elements.entrySet();
    }

    public InfoVar getElement(String name) {
        List<String> l = Arrays.asList(name.split("\\."));
        return this.getElement(l);
    }

    public InfoVar getElement(List<String> path) {
        if (path.size() < 1) {
            return null;
        }
        if (path.size() == 1) {
            return this.elements.getOrDefault(path.get(0), null);
        }
        if (!this.elements.containsKey(path.get(0))) {
            return null;
        }
        return this.elements.get(path.get(0)).getElement(path.subList(1, path.size()));
    }

    public int getSize() {
        return this.size;
    }

    public InfoTree getParent() {
        return this.parentTree;
    }

    public void setParent(InfoTree infoTree) {
        this.parentTree = infoTree;
    }

    public InfoVar getNode() {
        return this.node;
    }
}

