/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.main_gui;

import io.github.kurrycat.mpkmod.gui.ComponentScreen;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.LabelConfiguration;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.LoadConfigPane;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.OptionsPane;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.SaveConfigPane;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.util.ArrayList;

public class MainGuiScreen
extends ComponentScreen {
    public OptionsPane optionsPane = null;
    public LoadConfigPane loadConfigPane = null;
    public SaveConfigPane saveConfigPane = null;

    @Override
    public boolean shouldCreateKeyBind() {
        return true;
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        this.reloadConfig();
        this.addChild(new Button("Save", new Vector2D(115.0, 5.0), new Vector2D(50.0, 20.0), mouseButton -> this.openPane(this.saveConfigPane)), 0, Anchor.BOTTOM_RIGHT);
        this.addChild(new Button("Load File", new Vector2D(60.0, 5.0), new Vector2D(50.0, 20.0), mouseButton -> this.openPane(this.loadConfigPane)), 0, Anchor.BOTTOM_RIGHT);
        this.addChild(new Button("Options", new Vector2D(5.0, 5.0), new Vector2D(50.0, 20.0), mouseButton -> this.openPane(this.optionsPane)), 0, Anchor.BOTTOM_RIGHT);
        this.optionsPane = new OptionsPane(Vector2D.ZERO, new Vector2D(0.6, 0.6));
        this.passPositionTo(this.optionsPane, 15, Anchor.CENTER);
        this.loadConfigPane = new LoadConfigPane(Vector2D.ZERO, new Vector2D(0.6, 1.0));
        this.passPositionTo(this.loadConfigPane, 15, Anchor.CENTER);
        this.saveConfigPane = new SaveConfigPane(Vector2D.ZERO, new Vector2D(0.6, 1.0));
        this.passPositionTo(this.saveConfigPane, 15, Anchor.CENTER);
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.closeAllPanes();
        LabelConfiguration.currentConfig.saveInCustom();
    }

    @Override
    public void render(Vector2D mouse, float partialTicks) {
        super.render(mouse, partialTicks);
    }

    @Override
    public void removeComponent(Component c) {
        LabelConfiguration.currentConfig.components.remove(c);
        this.reloadConfig();
    }

    @Override
    public void addComponent(Component c) {
        LabelConfiguration.currentConfig.components.add(c);
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.movableComponents = new ArrayList<Component>(LabelConfiguration.currentConfig.components);
        this.movableComponents.forEach(this::passPositionTo);
    }
}

