/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

public class ButtonMS {
    private final Long nanos;
    private final boolean state;
    private final Button button;

    private ButtonMS(Button button, Long nanos, boolean state) {
        this.button = button;
        this.nanos = nanos;
        this.state = state;
    }

    public static ButtonMS of(Button button, long nanos, boolean state) {
        return new ButtonMS(button, nanos, state);
    }

    public static ButtonMS down(Button button, long nanos) {
        return new ButtonMS(button, nanos, true);
    }

    public static ButtonMS up(Button button, long nanos) {
        return new ButtonMS(button, nanos, false);
    }

    public boolean isState(boolean state) {
        return state == this.state;
    }

    public String getKey() {
        return this.button.key;
    }

    public Button getButton() {
        return this.button;
    }

    public String toString() {
        return "ButtonMS{" + (Object)((Object)this.button) + "." + (this.state ? "DOWN" : "UP") + ": " + this.nanos + "}";
    }

    public Integer msFrom(ButtonMS before) {
        return (int)((double)(this.nanos - before.nanos) / 1000000.0);
    }

    public static enum Button {
        FORWARD("W"),
        LEFT("A"),
        BACKWARD("S"),
        RIGHT("D"),
        SPRINT("P"),
        SNEAK("N"),
        JUMP("J");

        public static final int[] ONLY_MOVE_INDICES;
        public static final int[] ONLY_MOVE_MOD_INDICES;
        public static final int[] ALL;
        private final String key;

        private Button(String button) {
            this.key = button;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "Button." + this.key;
        }

        static {
            ONLY_MOVE_INDICES = new int[]{0, 1, 2, 3, 6};
            ONLY_MOVE_MOD_INDICES = new int[]{4, 5, 6};
            ALL = new int[]{0, 1, 2, 3, 4, 5, 6};
        }
    }
}

