/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

import io.github.kurrycat.mpkmod.ticks.ButtonMS;
import io.github.kurrycat.mpkmod.ticks.ButtonMSList;
import io.github.kurrycat.mpkmod.util.Copyable;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TimingInput
implements Copyable<TimingInput> {
    public boolean W;
    public boolean A;
    public boolean S;
    public boolean D;
    public boolean P;
    public boolean N;
    public boolean J;
    public Boolean G = null;
    public ButtonMSList msList = new ButtonMSList();

    public TimingInput(String inputString) {
        this.W = inputString.contains("W");
        this.A = inputString.contains("A");
        this.S = inputString.contains("S");
        this.D = inputString.contains("D");
        this.P = inputString.contains("P");
        this.N = inputString.contains("N");
        this.J = inputString.contains("J");
        if (inputString.contains("G")) {
            this.G = !inputString.contains("!G");
        }
    }

    public TimingInput(boolean W, boolean A, boolean S, boolean D, boolean P, boolean N, boolean J, Boolean G) {
        this.W = W;
        this.A = A;
        this.S = S;
        this.D = D;
        this.P = P;
        this.N = N;
        this.J = J;
        this.G = G;
    }

    public static TimingInput stopTick() {
        return new TimingInput(false, false, false, false, false, false, false, true);
    }

    public static Tuple<ButtonMS.Button, ButtonMS.Button> findMSButtons(TimingInput before, TimingInput after, List<TimingInput> curr) {
        boolean[] befInputs = before.inputBoolList();
        boolean[] aftInputs = after.inputBoolList();
        List<boolean[]> curInputsList = curr.stream().map(TimingInput::inputBoolList).collect(Collectors.toList());
        ButtonMS.Button[] allButtons = ButtonMS.Button.values();
        int onlyPressedCurr = TimingInput.findSingleOnlyPressedCurr(befInputs, aftInputs, curInputsList);
        if (onlyPressedCurr != -1) {
            return new Tuple<ButtonMS.Button, ButtonMS.Button>(allButtons[onlyPressedCurr], allButtons[onlyPressedCurr]);
        }
        for (int i = 0; i < curr.size() - 1; ++i) {
            if (curr.get(i).equalsIgnoreJump(curr.get(i + 1))) continue;
            return null;
        }
        boolean[] curInputs = curr.get(0).inputBoolList();
        Tuple<Integer, Integer> interruptedByMovMod = TimingInput.findInterruptedByMove(befInputs, curInputs, aftInputs);
        if (interruptedByMovMod.getFirst() != -1 && interruptedByMovMod.getSecond() != -1) {
            return new Tuple<ButtonMS.Button, ButtonMS.Button>(allButtons[interruptedByMovMod.getFirst()], allButtons[interruptedByMovMod.getSecond()]);
        }
        return null;
    }

    public boolean[] inputBoolList() {
        return new boolean[]{this.W, this.A, this.S, this.D, this.P, this.N, this.J};
    }

    private static int findSingleOnlyPressedCurr(boolean[] befInputs, boolean[] aftInputs, List<boolean[]> curInputs) {
        int index = -1;
        for (int i = 0; i < befInputs.length - 1; ++i) {
            int finalI = i;
            if (befInputs[i] || !curInputs.stream().allMatch(b -> b[finalI]) || aftInputs[i]) continue;
            if (index == -1) {
                index = i;
                continue;
            }
            return -1;
        }
        return index;
    }

    public boolean equalsIgnoreJump(TimingInput other) {
        return this.W == other.W && this.A == other.A && this.S == other.S && this.D == other.D && this.P == other.P && this.N == other.N;
    }

    private static Tuple<Integer, Integer> findInterruptedByMove(boolean[] befInputs, boolean[] curInputs, boolean[] aftInputs) {
        int first = TimingInput.findMovButtonDiff(befInputs, curInputs);
        int second = TimingInput.findFirstButtonDiff(curInputs, aftInputs);
        return new Tuple<Integer, Integer>(first, second);
    }

    private static int findMovButtonDiff(boolean[] befInputs, boolean[] curInputs) {
        int diffIndex = -1;
        for (int i : ButtonMS.Button.ONLY_MOVE_INDICES) {
            if (befInputs[i] == curInputs[i]) continue;
            diffIndex = i;
        }
        return diffIndex;
    }

    private static int findFirstButtonDiff(boolean[] curInputs, boolean[] aftInputs) {
        for (int i : ButtonMS.Button.ALL) {
            if (curInputs[i] || !aftInputs[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isStopTick() {
        return !this.W && !this.A && !this.S && !this.D && !this.P && !this.N && !this.J && this.G != null && this.G != false;
    }

    public int hashCode() {
        return Objects.hash(this.W, this.A, this.S, this.D, this.P, this.N, this.J, this.G);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingInput that = (TimingInput)o;
        return this.W == that.W && this.A == that.A && this.S == that.S && this.D == that.D && this.P == that.P && this.N == that.N && this.J == that.J && (this.G == null || that.G == null || this.G == that.G);
    }

    public String toString() {
        return this.toInputs() + (this.G == null ? "" : (this.G != false ? "G" : "!G"));
    }

    public String toInputs() {
        return (this.W ? "W" : "") + (this.A ? "A" : "") + (this.S ? "S" : "") + (this.D ? "D" : "") + (this.P ? "P" : "") + (this.N ? "N" : "") + (this.J ? "J" : "");
    }

    @Override
    public TimingInput copy() {
        return new TimingInput(this.W, this.A, this.S, this.D, this.P, this.N, this.J, this.G);
    }
}

